/*
 * Decompiled with CFR 0.152.
 */
package example.audiodemo;

import example.audiodemo.BBall;
import example.audiodemo.SmallBall;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.ToneControl;

public class BallCanvas
extends Canvas
implements CommandListener {
    private Display display;
    private Player player;
    private int[] notes = new int[]{68, 72, 70, 74, 76};
    private int[] colors = new int[]{255, 65280, 0xFF0000, 65535, 0xFF00FF};
    private SmallBall[] balls;
    private int numBalls;
    private int width;
    private int height;
    private boolean paused;
    private Command backCommand = new Command("Back", 2, 1);
    private Command pauseCommand = new Command("Pause", 2, 1);
    private Command playCommand = new Command("Play", 2, 1);
    private boolean playerCreated;

    public BallCanvas(Display d, int maxBalls, int bg) {
        this.display = d;
        this.balls = new SmallBall[maxBalls];
        this.width = this.getWidth();
        this.height = this.getHeight();
        this.playerCreated = this.initPlayer(bg);
        this.balls[0] = new SmallBall(this, 0, 0, this.width, this.height - 12);
        this.balls[0].setColor(this.colors[0]);
        this.numBalls = 1;
        this.paused = true;
        this.addCommand(this.backCommand);
        this.addCommand(this.pauseCommand);
        this.setCommandListener(this);
    }

    boolean needAlert() {
        return !this.playerCreated;
    }

    boolean initPlayer(int bg) {
        try {
            switch (bg) {
                case 1: {
                    this.player = Manager.createPlayer((String)BBall.wavbgUrl);
                    break;
                }
                case 2: {
                    byte d = 8;
                    byte C4 = 60;
                    byte D4 = 62;
                    byte E4 = 64;
                    byte G4 = 67;
                    byte rest = -1;
                    byte[] mySequence = new byte[]{-2, 1, -3, 30, -5, 0, E4, d, D4, d, C4, d, D4, d, E4, d, E4, d, E4, d, rest, d, -6, 0, -7, 0, D4, d, D4, d, D4, d, rest, d, E4, d, G4, d, G4, d, rest, d, -7, 0, D4, d, D4, d, E4, d, D4, d, C4, d, rest, d};
                    this.player = Manager.createPlayer((String)"device://tone");
                    this.player.realize();
                    ToneControl c = (ToneControl)this.player.getControl("ToneControl");
                    c.setSequence(mySequence);
                    break;
                }
                default: {
                    this.player = null;
                }
            }
            if (this.player != null) {
                this.player.setLoopCount(-1);
                this.player.start();
            }
        }
        catch (Exception ex) {
            if (this.player != null) {
                this.player.close();
            }
            this.player = null;
            return false;
        }
        return true;
    }

    protected void paint(Graphics g) {
        g.setColor(0xFFFFFF);
        g.fillRect(0, 0, this.width - 1, this.height - 1);
        g.setColor(0);
        g.drawRect(1, 1, this.width - 2, this.height - 2);
        for (int i = 0; i < this.numBalls; ++i) {
            this.balls[i].paint(g);
        }
    }

    public void keyPressed(int keyCode) {
        int action = this.getGameAction(keyCode);
        switch (action) {
            case 2: {
                if (this.numBalls <= 0) break;
                --this.numBalls;
                this.balls[this.numBalls].stop = true;
                this.balls[this.numBalls] = null;
                break;
            }
            case 5: {
                if (this.numBalls >= this.balls.length) break;
                this.balls[this.numBalls] = new SmallBall(this, 0, 0, this.width, this.height - 12);
                this.balls[this.numBalls].setNote(this.notes[this.numBalls]);
                this.balls[this.numBalls].setColor(this.colors[this.numBalls]);
                new Thread(this.balls[this.numBalls]).start();
                ++this.numBalls;
                break;
            }
            case 1: {
                SmallBall.faster();
                break;
            }
            case 6: {
                SmallBall.slower();
            }
        }
        this.repaint();
    }

    void destroy() {
        for (int i = 0; i < this.balls.length; ++i) {
            if (this.balls[i] == null) continue;
            this.balls[i].stop = true;
            this.balls[i] = null;
        }
        this.numBalls = 0;
        if (this.player != null) {
            this.player.close();
            this.player = null;
        }
        BBall.getInstance().game = null;
    }

    boolean isPaused() {
        return this.paused;
    }

    void pause() {
        if (!this.paused) {
            this.paused = true;
            for (int i = 0; i < this.balls.length && this.balls[i] != null; ++i) {
                this.balls[i].stop = true;
            }
            try {
                if (this.player != null) {
                    this.player.stop();
                }
            }
            catch (MediaException mediaException) {
                // empty catch block
            }
        }
        this.repaint();
    }

    void start() {
        if (this.paused) {
            this.paused = false;
            for (int i = 0; i < this.balls.length && this.balls[i] != null; ++i) {
                Thread t = new Thread(this.balls[i]);
                t.start();
            }
            if (this.player != null) {
                try {
                    this.player.start();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.repaint();
        }
    }

    public void commandAction(Command c, Displayable s) {
        if (c == this.backCommand) {
            this.destroy();
            this.display.setCurrent((Displayable)BBall.getList());
        } else if (c == this.pauseCommand) {
            this.pause();
            this.removeCommand(this.pauseCommand);
            this.addCommand(this.playCommand);
        } else if (c == this.playCommand) {
            this.removeCommand(this.playCommand);
            this.addCommand(this.pauseCommand);
            this.start();
        }
    }
}

