/*
 * Decompiled with CFR 0.152.
 */
package example.audiodemo;

import example.audiodemo.MixTest;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.ToneControl;
import javax.microedition.media.control.VolumeControl;

public class MixCanvas
extends Canvas
implements CommandListener,
Runnable {
    private static final String TITLE_TEXT = "audio player";
    private static final int[] notes = new int[]{69, 70, 71, 72, 73, 74, 75, 76};
    static Player wavPlayer = null;
    static Player tonePlayer = null;
    static Image logo = null;
    private int idx = 0;
    private int ip = 0;
    Display parentDisplay;
    private Command backCommand = new Command("Back", 2, 1);
    private Command playCommand = new Command("Play", 8, 1);
    private Command pauseCommand = new Command("Pause", 8, 1);
    private Command toneCommand = new Command("Tone", 8, 1);
    private Alert alert;

    public MixCanvas(Display parentDisplay) {
        this.parentDisplay = parentDisplay;
        this.initialize();
    }

    void initialize() {
        this.addCommand(this.backCommand);
        this.setCommandListener(this);
        try {
            logo = Image.createImage((String)"/icons/logo.png");
        }
        catch (Exception ex) {
            logo = null;
        }
        if (logo == null) {
            System.out.println("can not load logo.png");
        }
        this.alert = new Alert("Warning", "Can not create player", null, null);
        this.alert.setTimeout(1000);
    }

    public void commandAction(Command c, Displayable s) {
        if (s == this) {
            if (c == this.backCommand) {
                this.stopSound();
                this.parentDisplay.setCurrent((Displayable)MixTest.getList());
            } else if (c == this.toneCommand) {
                try {
                    Manager.playTone((int)notes[this.ip], (int)1000, (int)100);
                    ++this.ip;
                    if (this.ip >= 8) {
                        this.ip = 0;
                    }
                }
                catch (Exception ex) {
                    System.out.println("get an exception for tone");
                }
            } else if (c == this.playCommand) {
                this.playSound();
            } else if (c == this.pauseCommand) {
                this.pauseSound();
            }
        }
    }

    public void setIndex(int idx) {
        this.idx = idx;
    }

    private void createWavPlayer() {
        new Thread(this).start();
    }

    public void run() {
        try {
            if (wavPlayer == null) {
                wavPlayer = Manager.createPlayer((String)MixTest.wavUrl);
                wavPlayer.setLoopCount(-1);
            }
            wavPlayer.start();
        }
        catch (Exception ex) {
            if (wavPlayer != null) {
                wavPlayer.close();
                wavPlayer = null;
            }
            this.parentDisplay.setCurrent((Displayable)this.alert);
        }
    }

    private void createTonePlayer() {
        byte d = 8;
        byte C4 = 60;
        byte D4 = 62;
        byte E4 = 64;
        byte G4 = 67;
        byte rest = -1;
        byte[] mySequence = new byte[]{-2, 1, -3, 30, -5, 0, E4, d, D4, d, C4, d, D4, d, E4, d, E4, d, E4, d, rest, d, -6, 0, -7, 0, D4, d, D4, d, D4, d, rest, d, E4, d, G4, d, G4, d, rest, d, -7, 0, D4, d, D4, d, E4, d, D4, d, C4, d, rest, d};
        try {
            if (tonePlayer == null) {
                tonePlayer = Manager.createPlayer((String)"device://tone");
                tonePlayer.setLoopCount(-1);
                tonePlayer.realize();
                ToneControl tc = (ToneControl)tonePlayer.getControl("javax.microedition.media.control.ToneControl");
                tc.setSequence(mySequence);
            }
            tonePlayer.start();
        }
        catch (Exception ex) {
            if (tonePlayer != null) {
                tonePlayer.close();
                tonePlayer = null;
            }
            this.parentDisplay.setCurrent((Displayable)this.alert);
        }
    }

    public void playSound() {
        switch (this.idx) {
            case 0: {
                this.addCommand(this.toneCommand);
                this.createWavPlayer();
                break;
            }
            case 1: {
                this.addCommand(this.toneCommand);
                this.createTonePlayer();
                break;
            }
            case 2: {
                this.removeCommand(this.playCommand);
                this.addCommand(this.pauseCommand);
                this.createWavPlayer();
                this.createTonePlayer();
            }
        }
    }

    public void stopSound() {
        if (tonePlayer != null) {
            tonePlayer.close();
            tonePlayer = null;
        }
        if (wavPlayer != null) {
            wavPlayer.close();
            wavPlayer = null;
        }
        switch (this.idx) {
            case 0: 
            case 1: {
                this.removeCommand(this.toneCommand);
                break;
            }
            case 2: {
                this.removeCommand(this.pauseCommand);
                this.removeCommand(this.playCommand);
            }
        }
    }

    public void pauseSound() {
        this.removeCommand(this.pauseCommand);
        this.addCommand(this.playCommand);
        try {
            if (wavPlayer != null) {
                wavPlayer.stop();
            }
            if (tonePlayer != null) {
                tonePlayer.stop();
            }
        }
        catch (MediaException mediaException) {
            // empty catch block
        }
    }

    public void paint(Graphics g) {
        int w = this.getWidth();
        int h = this.getHeight();
        String cname = "";
        switch (this.idx) {
            case 0: {
                cname = "test-wav.wav";
                break;
            }
            case 1: {
                cname = "tone seq";
                break;
            }
            case 2: {
                cname = "wave+toneseq";
            }
        }
        g.setColor(0);
        g.fillRect(0, 0, w, h);
        if (logo != null) {
            g.drawImage(logo, w / 2, 30, 17);
        }
        g.setColor(0xFF7F00);
        g.drawString("audio Player", w / 2, 8, 17);
        g.drawString(cname, 0, 84, 20);
    }

    protected void keyPressed(int keycode) {
        switch (keycode) {
            case 42: {
                this.changeVolume(-10);
                break;
            }
            case 35: {
                this.changeVolume(10);
            }
        }
    }

    private void changeVolume(int diff) {
        int cv;
        VolumeControl vc;
        if (wavPlayer != null && (vc = (VolumeControl)wavPlayer.getControl("VolumeControl")) != null) {
            cv = vc.getLevel();
            cv += diff;
            cv = vc.setLevel(cv);
        }
        if (tonePlayer != null && (vc = (VolumeControl)tonePlayer.getControl("VolumeControl")) != null) {
            cv = vc.getLevel();
            int n = vc.setLevel(cv += diff);
        }
    }
}

