/*
 * Decompiled with CFR 0.152.
 */
package example.alert;

import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.midlet.MIDlet;

public class AlertDemo
extends MIDlet
implements CommandListener {
    private final String[] typeStrings = new String[]{"Alarm", "Confirmation", "Error", "Info", "Warning"};
    private final String[] timeoutStrings = new String[]{"2 Seconds", "4 Seconds", "8 Seconds", "Forever"};
    private final AlertType[] alertTypes = new AlertType[]{AlertType.ALARM, AlertType.CONFIRMATION, AlertType.ERROR, AlertType.INFO, AlertType.WARNING};
    private final int[] timeouts = new int[]{2000, 4000, 8000, -2};
    private static final int SECOND = 1000;
    private Form mainForm;
    private ChoiceGroup typeGroup;
    private ChoiceGroup timeoutGroup;
    private ChoiceGroup optionsGroup;
    private Alert alert;
    private Command showCommand;
    private Command exitCommand;

    private void initialize() {
        this.getDisplay().setCurrent((Displayable)this.get_mainForm());
    }

    public Display getDisplay() {
        return Display.getDisplay((MIDlet)this);
    }

    public void exitMIDlet() {
        this.getDisplay().setCurrent(null);
        this.destroyApp(true);
        this.notifyDestroyed();
    }

    public void commandAction(Command command, Displayable displayable) {
        if (displayable == this.mainForm) {
            if (command == this.showCommand) {
                this.setUpAlert();
                this.getDisplay().setCurrent(this.get_alert(), (Displayable)this.get_mainForm());
            } else if (command == this.exitCommand) {
                this.exitMIDlet();
            }
        }
    }

    public Form get_mainForm() {
        if (this.mainForm == null) {
            this.mainForm = new Form("Alert Options", new Item[]{this.get_typeGroup(), this.get_timeoutGroup(), this.get_optionsGroup()});
            this.mainForm.addCommand(this.get_showCommand());
            this.mainForm.addCommand(this.get_exitCommand());
            this.mainForm.setCommandListener((CommandListener)this);
        }
        return this.mainForm;
    }

    public ChoiceGroup get_typeGroup() {
        if (this.typeGroup == null) {
            this.typeGroup = new ChoiceGroup("Type", 4, new String[0], new Image[0]);
            this.typeGroup.setSelectedFlags(new boolean[0]);
            this.fillTypeGroup();
        }
        return this.typeGroup;
    }

    public ChoiceGroup get_timeoutGroup() {
        if (this.timeoutGroup == null) {
            this.timeoutGroup = new ChoiceGroup("Timeout", 4, new String[0], new Image[0]);
            this.timeoutGroup.setSelectedFlags(new boolean[0]);
            this.fillTimeoutGroup();
        }
        return this.timeoutGroup;
    }

    public ChoiceGroup get_optionsGroup() {
        if (this.optionsGroup == null) {
            this.optionsGroup = new ChoiceGroup("Options", 2, new String[0], new Image[0]);
            this.optionsGroup.setSelectedFlags(new boolean[0]);
            this.get_optionsGroup().append("Show Indicator", null);
        }
        return this.optionsGroup;
    }

    public Alert get_alert() {
        if (this.alert == null) {
            this.alert = new Alert("Alert", null, null, AlertType.INFO);
            this.alert.setTimeout(-2);
        }
        return this.alert;
    }

    public Command get_showCommand() {
        if (this.showCommand == null) {
            this.showCommand = new Command("Show", 4, 1);
        }
        return this.showCommand;
    }

    public Command get_exitCommand() {
        if (this.exitCommand == null) {
            this.exitCommand = new Command("Exit", 7, 1);
        }
        return this.exitCommand;
    }

    private void fillTypeGroup() {
        for (int i = 0; i < this.typeStrings.length; ++i) {
            this.get_typeGroup().append(this.typeStrings[i], null);
        }
    }

    private void fillTimeoutGroup() {
        for (int i = 0; i < this.timeoutStrings.length; ++i) {
            this.get_timeoutGroup().append(this.timeoutStrings[i], null);
        }
    }

    private void setUpAlert() {
        int typeIndex = this.get_typeGroup().getSelectedIndex();
        this.get_alert().setType(this.alertTypes[typeIndex]);
        int timeoutIndex = this.get_timeoutGroup().getSelectedIndex();
        this.get_alert().setTimeout(this.timeouts[timeoutIndex]);
        this.get_alert().setString(this.typeStrings[typeIndex] + " Alert, Running " + this.timeoutStrings[timeoutIndex]);
        boolean[] SelectedFlags = new boolean[1];
        this.get_optionsGroup().getSelectedFlags(SelectedFlags);
        if (SelectedFlags[0]) {
            Gauge indicator = this.createIndicator(this.timeouts[timeoutIndex]);
            this.get_alert().setIndicator(indicator);
        }
    }

    private Gauge createIndicator(int maxValue) {
        if (maxValue == -2) {
            return new Gauge(null, false, -1, 2);
        }
        final int max = maxValue / 1000;
        final Gauge indicator = new Gauge(null, false, max, 0);
        new Thread(){

            public void run() {
                int value = 0;
                while (value < max) {
                    indicator.setValue(value);
                    ++value;
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }.start();
        return indicator;
    }

    public void startApp() {
        this.initialize();
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean unconditional) {
    }
}

