/*
 * Decompiled with CFR 0.152.
 */
package example.customitem;

import example.customitem.TextInput;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CustomItem;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemCommandListener;

public class Table
extends CustomItem
implements ItemCommandListener {
    private static final Command CMD_EDIT = new Command("Edit", 8, 1);
    private Display display;
    private int rows = 5;
    private int cols = 3;
    private int dx = 50;
    private int dy = 20;
    private static final int UPPER = 0;
    private static final int IN = 1;
    private static final int LOWER = 2;
    private int location = 0;
    private int currentX = 0;
    private int currentY = 0;
    private String[][] data = new String[this.rows][this.cols];

    public Table(String title, Display d) {
        super(title);
        this.display = d;
        this.setDefaultCommand(CMD_EDIT);
        this.setItemCommandListener(this);
    }

    protected int getMinContentHeight() {
        return this.rows * this.dy + 1;
    }

    protected int getMinContentWidth() {
        return this.cols * this.dx + 1;
    }

    protected int getPrefContentHeight(int width) {
        return this.rows * this.dy + 1;
    }

    protected int getPrefContentWidth(int height) {
        return this.cols * this.dx + 1;
    }

    protected void paint(Graphics g, int w, int h) {
        int i;
        for (i = 0; i <= this.rows; ++i) {
            g.drawLine(0, i * this.dy, this.cols * this.dx, i * this.dy);
        }
        for (i = 0; i <= this.cols; ++i) {
            g.drawLine(i * this.dx, 0, i * this.dx, this.rows * this.dy);
        }
        int oldColor = g.getColor();
        g.setColor(0xD0D0D0);
        g.fillRect(this.currentX * this.dx + 1, this.currentY * this.dy + 1, this.dx - 1, this.dy - 1);
        g.setColor(oldColor);
        for (int i2 = 0; i2 < this.rows; ++i2) {
            for (int j = 0; j < this.cols; ++j) {
                if (this.data[i2][j] == null) continue;
                int oldClipX = g.getClipX();
                int oldClipY = g.getClipY();
                int oldClipWidth = g.getClipWidth();
                int oldClipHeight = g.getClipHeight();
                g.setClip(j * this.dx + 1, i2 * this.dy, this.dx - 1, this.dy - 1);
                g.drawString(this.data[i2][j], j * this.dx + 2, (i2 + 1) * this.dy - 2, 36);
                g.setClip(oldClipX, oldClipY, oldClipWidth, oldClipHeight);
            }
        }
    }

    protected boolean traverse(int dir, int viewportWidth, int viewportHeight, int[] visRect_inout) {
        switch (dir) {
            case 6: {
                if (this.location == 0) {
                    this.location = 1;
                    break;
                }
                if (this.currentY < this.rows - 1) {
                    ++this.currentY;
                    this.repaint(this.currentX * this.dx, (this.currentY - 1) * this.dy, this.dx, this.dy);
                    this.repaint(this.currentX * this.dx, this.currentY * this.dy, this.dx, this.dy);
                    break;
                }
                this.location = 2;
                return false;
            }
            case 1: {
                if (this.location == 2) {
                    this.location = 1;
                    break;
                }
                if (this.currentY > 0) {
                    --this.currentY;
                    this.repaint(this.currentX * this.dx, (this.currentY + 1) * this.dy, this.dx, this.dy);
                    this.repaint(this.currentX * this.dx, this.currentY * this.dy, this.dx, this.dy);
                    break;
                }
                this.location = 0;
                return false;
            }
            case 2: {
                if (this.currentX <= 0) break;
                --this.currentX;
                this.repaint((this.currentX + 1) * this.dx, this.currentY * this.dy, this.dx, this.dy);
                this.repaint(this.currentX * this.dx, this.currentY * this.dy, this.dx, this.dy);
                break;
            }
            case 5: {
                if (this.currentX >= this.cols - 1) break;
                ++this.currentX;
                this.repaint((this.currentX - 1) * this.dx, this.currentY * this.dy, this.dx, this.dy);
                this.repaint(this.currentX * this.dx, this.currentY * this.dy, this.dx, this.dy);
            }
        }
        visRect_inout[0] = this.currentX;
        visRect_inout[1] = this.currentY;
        visRect_inout[2] = this.dx;
        visRect_inout[3] = this.dy;
        return true;
    }

    public void setText(String text) {
        this.data[this.currentY][this.currentX] = text;
        this.repaint(this.currentY * this.dx, this.currentX * this.dy, this.dx, this.dy);
    }

    public void commandAction(Command c, Item i) {
        if (c == CMD_EDIT) {
            TextInput textInput = new TextInput(this.data[this.currentY][this.currentX], this, this.display);
            this.display.setCurrent((Displayable)textInput);
        }
    }
}

