/*
 * Decompiled with CFR 0.152.
 */
package example.textbox;

import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextBox;
import javax.microedition.lcdui.Ticker;
import javax.microedition.midlet.MIDlet;

public class TextBoxDemo
extends MIDlet
implements CommandListener {
    static final String[] textBoxLabels = new String[]{"Any Character", "E-Mail", "Number", "Decimal", "Phone", "Url"};
    static final int[] textBoxTypes = new int[]{0, 1, 2, 5, 3, 4};
    private Form mainForm;
    private StringItem stringItem1;
    private ChoiceGroup typeCG;
    private ChoiceGroup optionsCG;
    private Command showCommand;
    private Command exitCommand;
    private TextBox textBox;
    private Command backCommand;

    private void setUpTypeList() {
        for (int i = 0; textBoxLabels.length > i; ++i) {
            this.get_typeCG().append(textBoxLabels[i], null);
        }
    }

    private void setUpTextBox() {
        this.textBox = null;
        int i = this.get_typeCG().getSelectedIndex();
        String title = textBoxLabels[i];
        int t = textBoxTypes[i];
        boolean[] flags = new boolean[2];
        this.get_optionsCG().getSelectedFlags(flags);
        if (flags[0]) {
            t |= 0x10000;
        }
        if (flags[1]) {
            this.get_textBox().setTicker(new Ticker("TextBox: " + title));
        }
        this.get_textBox().setTitle(title);
        this.get_textBox().setConstraints(t);
    }

    private void initialize() {
        this.getDisplay().setCurrent((Displayable)this.get_mainForm());
    }

    public Display getDisplay() {
        return Display.getDisplay((MIDlet)this);
    }

    public void exitMIDlet() {
        this.getDisplay().setCurrent(null);
        this.destroyApp(true);
        this.notifyDestroyed();
    }

    public void commandAction(Command command, Displayable displayable) {
        if (displayable == this.mainForm) {
            if (command == this.showCommand) {
                this.setUpTextBox();
                this.getDisplay().setCurrent((Displayable)this.get_textBox());
            } else if (command == this.exitCommand) {
                this.exitMIDlet();
            }
        } else if (displayable == this.textBox && command == this.backCommand) {
            this.getDisplay().setCurrent((Displayable)this.get_mainForm());
        }
    }

    public Form get_mainForm() {
        if (this.mainForm == null) {
            this.setUpTypeList();
            this.mainForm = new Form("TextBox Demo", new Item[]{this.get_stringItem1(), this.get_typeCG(), this.get_optionsCG()});
            this.mainForm.addCommand(this.get_showCommand());
            this.mainForm.addCommand(this.get_exitCommand());
            this.mainForm.setCommandListener((CommandListener)this);
        }
        return this.mainForm;
    }

    public StringItem get_stringItem1() {
        if (this.stringItem1 == null) {
            this.stringItem1 = new StringItem(null, "Select a TextBox type");
        }
        return this.stringItem1;
    }

    public ChoiceGroup get_typeCG() {
        if (this.typeCG == null) {
            this.typeCG = new ChoiceGroup("Choose Type", 1, new String[0], new Image[0]);
            this.typeCG.setSelectedFlags(new boolean[0]);
        }
        return this.typeCG;
    }

    public ChoiceGroup get_optionsCG() {
        if (this.optionsCG == null) {
            this.optionsCG = new ChoiceGroup("Options", 2, new String[]{"As Password", "Show Ticker"}, new Image[]{null, null});
            this.optionsCG.setSelectedFlags(new boolean[]{false, false});
        }
        return this.optionsCG;
    }

    public Command get_showCommand() {
        if (this.showCommand == null) {
            this.showCommand = new Command("Show", 1, 1);
        }
        return this.showCommand;
    }

    public Command get_exitCommand() {
        if (this.exitCommand == null) {
            this.exitCommand = new Command("Exit", 7, 1);
        }
        return this.exitCommand;
    }

    public TextBox get_textBox() {
        if (this.textBox == null) {
            this.textBox = new TextBox(null, null, 120, 0);
            this.textBox.addCommand(this.get_backCommand());
            this.textBox.setCommandListener((CommandListener)this);
        }
        return this.textBox;
    }

    public Command get_backCommand() {
        if (this.backCommand == null) {
            this.backCommand = new Command("Back", 2, 1);
        }
        return this.backCommand;
    }

    public void startApp() {
        this.initialize();
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean unconditional) {
    }
}

