/*
 * Decompiled with CFR 0.152.
 */
package example.auction2;

import example.About;
import java.io.IOException;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Choice;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.DateField;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemCommandListener;
import javax.microedition.lcdui.ItemStateListener;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextBox;
import javax.microedition.lcdui.TextField;
import javax.microedition.lcdui.Ticker;
import javax.microedition.midlet.MIDlet;

public class NewTicketAuction
extends MIDlet
implements CommandListener {
    Display display;
    Alert splashScreenAlert;
    static final int DefaultTimeout = 2000;
    Image splashScreen;
    boolean imageLoaded;
    Band band = new Band();
    Login login = new Login();
    TextBox addBand;
    RmBand rmBand = new RmBand();
    static final Command BACK_CMD = new Command("Back", 2, 1);
    static final Command SAVE_CMD = new Command("Save", 1, 2);
    static final Command NEXT_CMD = new Command("Next", 1, 2);
    static final Command SUBMIT_CMD = new Command("Submit", 8, 2);
    static final Command AUCTION_CMD = new Command("Auction", 8, 2);
    static final Command CANCEL_CMD = new Command("Cancel", 3, 1);
    static final Command STOP_CMD = new Command("Stop", 6, 1);
    List mainMenu;
    List cateMenu;
    List ticketList;
    Ticker ticker;
    Alert notImpl;
    Alert savedMsg;
    Alert alertMsg;
    Form band_ticket_Form;
    Form ticketForm;
    Form enterForm;
    Form bidForm;
    Form submitMsg;
    TextField enterText;
    ChoiceGroup bandCg;
    ChoiceGroup auctionCg;
    StringItem auctionName;
    UpdateAlert updateAlert = new UpdateAlert();
    Gauge submitGauge;
    Timer TimerService;
    SetMenuForm setMenu2 = new SetMenuForm();
    String _bandName;
    int _bandIndex = 0;
    static final Command EXIT_CMD = new Command("Exit", 7, 1);
    static final Command ABOUT_CMD = new Command("About Tickets", 5, 1);
    static final Command SHOW_CMD = new Command("Show Auctions", 1, 1);
    static final Command ADD_CMD = new Command("Add Bands", 1, 1);
    static final Command RMV_CMD = new Command("Remove Bands", 1, 2);
    static final Command SETTING_CMD = new Command("Settings", 1, 3);
    static final Command SHOW_INFO_CMD = new Command("Show More Info", 8, 1);
    static final Command MAKE_BID_CMD = new Command("Make a Bid", 8, 2);
    static final Command SET_ALERT_CMD = new Command("Set an Alert", 8, 3);
    static final Command BAND_CMD = new Command("Bands", 1, 1);
    private boolean firstTime;

    public NewTicketAuction() {
        this.display = Display.getDisplay((MIDlet)this);
        this.notImpl = new Alert("Sorry!!!", "Not Implemented", null, null);
        this.savedMsg = new Alert(null, "Your new settings have been saved!", null, null);
        this.alertMsg = new Alert(null, "Your alerts have been saved!", null, null);
        this.submitGauge = new Gauge("", false, 100, 0);
        this.submitMsg = new Form("Submitting bid...");
        this.submitMsg.append((Item)this.submitGauge);
        this.submitMsg.addCommand(STOP_CMD);
        this.submitMsg.setCommandListener((CommandListener)this);
        this.ticker = new Ticker("");
        this.ticker.setString(this.band.toTickerString(null));
        this.band_ticket_Form = new Form("Welcome To Tickets");
        this.band_ticket_Form.addCommand(SHOW_INFO_CMD);
        this.band_ticket_Form.addCommand(MAKE_BID_CMD);
        this.band_ticket_Form.addCommand(SET_ALERT_CMD);
        this.band_ticket_Form.addCommand(ADD_CMD);
        this.band_ticket_Form.addCommand(RMV_CMD);
        this.band_ticket_Form.addCommand(SETTING_CMD);
        this.band_ticket_Form.addCommand(ABOUT_CMD);
        this.band_ticket_Form.addCommand(EXIT_CMD);
        this.band_ticket_Form.setCommandListener((CommandListener)this);
        this.band_ticket_Form.setTicker(this.ticker);
        this.bandCg = new ChoiceGroup("Choose a Band", 4);
        this.band_ticket_Form.append((Item)this.bandCg);
        String[] list = this.band.getList();
        for (int i = 0; i < list.length; ++i) {
            this.bandCg.append(list[i], null);
        }
        String bandName = this.band.getName(this.bandCg.getSelectedIndex());
        this.auctionCg = new ChoiceGroup(bandName + " Auctions:", 1);
        this.auctionCg.setLayout(2048);
        this.band_ticket_Form.append((Item)this.auctionCg);
        this.reconstructList((Choice)this.auctionCg, this.band.getTicketList(bandName));
        this.band_ticket_Form.setItemStateListener(new ItemStateListener(){

            public void itemStateChanged(Item item) {
                ChoiceGroup obj;
                if (item instanceof ChoiceGroup && (obj = (ChoiceGroup)item) == NewTicketAuction.this.bandCg) {
                    int idx = obj.getSelectedIndex();
                    String bandName = NewTicketAuction.this.band.getName(idx);
                    NewTicketAuction.this.auctionCg.setLabel(bandName + " Auctions:");
                    NewTicketAuction.this.reconstructList((Choice)NewTicketAuction.this.auctionCg, NewTicketAuction.this.band.getTicketList(bandName));
                }
            }
        });
        try {
            this.splashScreen = Image.createImage((String)"/example/auction2/images/splashScreen.png");
            this.imageLoaded = true;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.splashScreenAlert = new Alert("Welcome to Ticket Auction", "", this.splashScreen, AlertType.INFO);
        this.splashScreenAlert.setTimeout(2000);
        this.ticketForm = new Form("dummy");
        this.ticketForm.append("dummy");
        this.ticketForm.addCommand(BACK_CMD);
        this.ticketForm.addCommand(BAND_CMD);
        this.ticketForm.addCommand(MAKE_BID_CMD);
        this.ticketForm.addCommand(SET_ALERT_CMD);
        this.ticketForm.setCommandListener((CommandListener)this);
        this.enterText = new TextField("Tell me when bid reaches:", "", 10, 5);
        this.enterForm = new Form("Set an Alert");
        this.enterForm.append((Item)this.enterText);
        this.enterForm.addCommand(BACK_CMD);
        this.enterForm.addCommand(SAVE_CMD);
        this.enterForm.setCommandListener((CommandListener)this);
        this.addBand = new TextBox("Add Bands, Bands:", "", 100, 0);
        this.addBand.addCommand(BACK_CMD);
        this.addBand.addCommand(SAVE_CMD);
        this.addBand.setCommandListener((CommandListener)this);
        this.firstTime = true;
    }

    public void startApp() {
        if (this.firstTime) {
            this.display.setCurrent(this.splashScreenAlert, (Displayable)this.band_ticket_Form);
            this.firstTime = false;
        }
    }

    public void destroyApp(boolean unconditional) {
    }

    public void pauseApp() {
    }

    public void commandAction(Command c, Displayable s) {
        TextBox obj;
        if (s instanceof Form) {
            Form obj2 = (Form)s;
            if (obj2 == this.band_ticket_Form) {
                int idx;
                this._bandIndex = idx = this.auctionCg.getSelectedIndex();
                int bandIdx = this.bandCg.getSelectedIndex();
                String bandName = "";
                if (bandIdx >= 0) {
                    bandName = this.band.getName(bandIdx);
                }
                this._bandName = bandName;
                if (c == SHOW_INFO_CMD) {
                    this.deleteFormItem(this.ticketForm);
                    this.ticketForm.setTitle(this.band.getTicketDataTitle(bandName, idx));
                    this.band.getTicketData(this.ticketForm, bandName, idx);
                    this.display.setCurrent((Displayable)this.ticketForm);
                } else if (c == MAKE_BID_CMD) {
                    this.login.setBandAttributes(bandName, this._bandIndex);
                    this.deleteFormItem(this.login);
                    this.login.append((Item)this.login.id);
                    this.login.id.setLabel("Enter Your ID:");
                    this.login.append((Item)this.login.pd);
                    this.login.pd.setLabel("Enter PIN:");
                    this.login.append((Item)this.login.curBid);
                    this.login.append((Item)this.login.incBid);
                    this.login.append((Item)this.login.minBid);
                    this.login.append((Item)this.login.bidText);
                    this.login.id.setString(null);
                    this.login.pd.setString(null);
                    this.login.bidText.setString(null);
                    this.band.getTicketBidTitle(this.login, this._bandName, this._bandIndex);
                    this.display.setCurrent((Displayable)this.login);
                } else if (c == SET_ALERT_CMD) {
                    this.display.setCurrent((Displayable)this.enterForm);
                } else if (c == ADD_CMD) {
                    this.display.setCurrent((Displayable)this.addBand);
                } else if (c == RMV_CMD) {
                    this.display.setCurrent((Displayable)this.rmBand);
                } else if (c == SETTING_CMD) {
                    this.display.setCurrent((Displayable)this.setMenu2);
                } else if (c == ABOUT_CMD) {
                    About.showAbout(this.display);
                } else if (c == EXIT_CMD) {
                    this.notifyDestroyed();
                }
            } else if (obj2 == this.ticketForm) {
                if (c == BACK_CMD) {
                    this.display.setCurrent((Displayable)this.band_ticket_Form);
                } else if (c == BAND_CMD) {
                    this.display.setCurrent((Displayable)this.band_ticket_Form);
                } else if (c == MAKE_BID_CMD) {
                    this.login.setBandAttributes(this.band.getName(this.bandCg.getSelectedIndex()), this._bandIndex);
                    this.deleteFormItem(this.login);
                    this.login.append((Item)this.login.id);
                    this.login.id.setLabel("Enter Auction ID:");
                    this.login.append((Item)this.login.pd);
                    this.login.pd.setLabel("Enter PIN:");
                    this.login.append((Item)this.login.curBid);
                    this.login.append((Item)this.login.incBid);
                    this.login.append((Item)this.login.minBid);
                    this.login.append((Item)this.login.bidText);
                    this.login.id.setString(null);
                    this.login.pd.setString(null);
                    this.login.bidText.setString(null);
                    this.band.getTicketBidTitle(this.login, this._bandName, this._bandIndex);
                    this.display.setCurrent((Displayable)this.login);
                } else if (c == SET_ALERT_CMD) {
                    this.deleteFormItem(this.enterForm);
                    int selectedBand = this.bandCg.getSelectedIndex();
                    String ticketID = this.band.getTicketID(this.band.getName(selectedBand), this.login._bandIndex);
                    this.enterForm.append((Item)new StringItem("Auction:", this.band.getName(selectedBand) + " " + ticketID));
                    String curBid = this.band.getCurrentBid(this.band.getName(selectedBand), this.login._bandIndex);
                    this.enterForm.append((Item)new StringItem("Current Bid:", "$" + curBid));
                    this.enterForm.append((Item)this.enterText);
                    this.display.setCurrent((Displayable)this.enterForm);
                }
            } else if (obj2 == this.enterForm) {
                if (c == BACK_CMD) {
                    this.enterText.setString(null);
                    this.display.setCurrent((Displayable)this.band_ticket_Form);
                } else if (c == SAVE_CMD) {
                    this.updateAlert.set(this.band.getName(this.bandCg.getSelectedIndex()), this.enterText.getString());
                    this.display.setCurrent(this.alertMsg, (Displayable)this.band_ticket_Form);
                }
            } else if (obj2 == this.submitMsg && c == STOP_CMD) {
                this.TimerService.cancel();
                this.display.setCurrent((Displayable)this.login.confirm);
            }
        } else if (s instanceof TextBox && (obj = (TextBox)s) == this.addBand) {
            if (c == BACK_CMD) {
                this.display.setCurrent((Displayable)this.band_ticket_Form);
            } else if (c == SAVE_CMD) {
                this.updateBandList(this.addBand.getString());
                this.display.setCurrent(this.savedMsg, (Displayable)this.band_ticket_Form);
            }
        }
    }

    void updateBandList(String list) {
        if (list.length() == 0) {
            return;
        }
        Vector<String> vec = new Vector<String>();
        int fidx = 0;
        while (true) {
            int idx;
            if ((idx = list.indexOf(44, fidx)) == -1) break;
            vec.addElement(list.substring(fidx, idx));
            fidx = idx + 1;
        }
        vec.addElement(list.substring(fidx));
        for (int i = 0; i < vec.size(); ++i) {
            int j;
            String str = (String)vec.elementAt(i);
            int len = str.length();
            for (j = 0; j < len && str.charAt(j) == ' '; ++j) {
            }
            if (j == len) continue;
            if (j == 0) {
                this.band.add(str);
                continue;
            }
            this.band.add(str.substring(j));
        }
        this.reconstructBandTicketForm(this.band.getList());
        this.rmBand.reset();
    }

    void reconstructBandTicketForm(String[] items) {
        if (items == null || items.length == 0) {
            this.bandCg.deleteAll();
            this.auctionCg.setLabel(null);
            this.auctionCg.deleteAll();
            return;
        }
        this.reconstructList((Choice)this.bandCg, items);
        this.bandCg.setSelectedIndex(0, true);
        String bandName = this.band.getName(this.bandCg.getSelectedIndex());
        this.auctionCg.setLabel(bandName + " Auctions:");
        this.reconstructList((Choice)this.auctionCg, this.band.getTicketList(bandName));
    }

    void reconstructList(Choice list, String[] items) {
        list.deleteAll();
        for (int i = 0; i < items.length; ++i) {
            list.append(items[i], null);
        }
    }

    void deleteFormItem(Form f) {
        int num = f.size();
        while (--num >= 0) {
            f.delete(num);
        }
    }

    class SetMenuForm
    extends Form
    implements CommandListener,
    ItemStateListener {
        Timer timerService = new Timer();
        ChoiceGroup tickerCg = new ChoiceGroup("Ticker Display", 2);
        ChoiceGroup updatesCg;
        Gauge gauge;
        DateField dateTimeItem;
        int updateChoice;
        int volumeValue;
        boolean[] musicChoice;
        boolean systemCurrentDate = true;
        long setTimeMillisDelta;
        long curTimeMillisDelta;

        SetMenuForm() {
            super("Settings");
            this.tickerCg.append("Rock", null);
            this.tickerCg.append("Pop", null);
            this.tickerCg.append("Country", null);
            this.tickerCg.append("Alternative", null);
            this.tickerCg.append("Jazz", null);
            this.tickerCg.append("Classical", null);
            this.musicChoice = new boolean[]{false, false, false, true, false, false};
            this.append((Item)this.tickerCg);
            this.updatesCg = new ChoiceGroup("Updates", 1);
            this.updatesCg.append("Continuous", null);
            this.updatesCg.append("15 minutes", null);
            this.updatesCg.append("30 minutes", null);
            this.updatesCg.append("1 hour", null);
            this.updatesCg.append("3 hours", null);
            this.updateChoice = 0;
            this.append((Item)this.updatesCg);
            this.gauge = new Gauge(null, true, 40, 0);
            this.volumeValue = 0;
            this.append((Item)this.gauge);
            this.setItemStateListener(this);
            this.curTimeMillisDelta = 0L;
            this.setTimeMillisDelta = 0L;
            this.dateTimeItem = new DateField("Set Date:", 3){

                public void showNotify() {
                    long millis = System.currentTimeMillis();
                    if (SetMenuForm.this.curTimeMillisDelta != 0L) {
                        millis -= SetMenuForm.this.curTimeMillisDelta;
                    }
                    this.setDate(new Date(millis));
                }
            };
            this.append((Item)this.dateTimeItem);
            this.settings(this.musicChoice, this.updateChoice, this.volumeValue, this.setTimeMillisDelta);
            this.addCommand(BACK_CMD);
            this.addCommand(SAVE_CMD);
            this.setCommandListener(this);
        }

        public void settings(boolean[] musicChoice, int updateChoice, int volumeValue, long curTimeMillisDelta) {
            this.tickerCg.setSelectedFlags(musicChoice);
            this.updatesCg.setSelectedIndex(updateChoice, true);
            this.gauge.setValue(volumeValue);
            this.gauge.setLabel("Set Alert Volume: " + volumeValue);
            long millis = System.currentTimeMillis();
            if (curTimeMillisDelta != 0L) {
                millis -= curTimeMillisDelta;
            }
            this.dateTimeItem.setDate(new Date(millis));
        }

        public void commandAction(Command c, Displayable s) {
            if (c == SAVE_CMD) {
                this.tickerCg.getSelectedFlags(this.musicChoice);
                String str = NewTicketAuction.this.band.toTickerString(this.musicChoice);
                if (str != null) {
                    NewTicketAuction.this.ticker.setString(str);
                }
                this.updateChoice = this.updatesCg.getSelectedIndex();
                this.volumeValue = this.gauge.getValue();
                this.setTimeMillisDelta = this.curTimeMillisDelta;
                if (NewTicketAuction.this.updateAlert.hasDataToUpdate()) {
                    int idx = this.updatesCg.getSelectedIndex();
                    TimerTask timerClient = new TimerTask(){

                        public final void run() {
                            ((SetMenuForm)SetMenuForm.this).NewTicketAuction.this.updateAlert.show();
                        }
                    };
                    switch (idx) {
                        case 0: {
                            this.timerService.schedule(timerClient, 3000L);
                            break;
                        }
                        case 1: {
                            this.timerService.schedule(timerClient, 3000L);
                            break;
                        }
                        case 2: {
                            this.timerService.schedule(timerClient, 3000L);
                            break;
                        }
                        case 3: {
                            this.timerService.schedule(timerClient, 3000L);
                            break;
                        }
                        case 4: {
                            this.timerService.schedule(timerClient, 3000L);
                        }
                    }
                }
                NewTicketAuction.this.display.setCurrent(NewTicketAuction.this.savedMsg, (Displayable)NewTicketAuction.this.band_ticket_Form);
            } else if (c == BACK_CMD) {
                NewTicketAuction.this.display.setCurrent((Displayable)NewTicketAuction.this.band_ticket_Form);
                this.settings(this.musicChoice, this.updateChoice, this.volumeValue, this.setTimeMillisDelta);
            }
        }

        public void itemStateChanged(Item item) {
            if (item == this.gauge) {
                int currentValue = this.gauge.getValue();
                this.gauge.setLabel("Set Alert Volume: " + String.valueOf(currentValue));
            } else if (item == this.dateTimeItem) {
                this.curTimeMillisDelta = System.currentTimeMillis() - this.dateTimeItem.getDate().getTime();
            }
        }
    }

    class UpdateAlert {
        String band = "";
        String bid = "";
        Alert soundAlert = new Alert("Alert", "", null, AlertType.ALARM);

        UpdateAlert() {
            this.soundAlert.setTimeout(-2);
        }

        void set(String band, String bid) {
            this.band = band;
            this.bid = bid;
        }

        boolean hasDataToUpdate() {
            return this.band != null && this.band != "" && this.bid != null && this.bid != "";
        }

        void show() {
            if (this.hasDataToUpdate()) {
                String s = new String(this.band + "\n" + "ticket bids\n" + "have reached\n" + "$" + this.bid);
                this.soundAlert.setString(s);
                NewTicketAuction.this.display.setCurrent((Displayable)this.soundAlert);
            }
        }
    }

    class RmBand
    extends List
    implements CommandListener {
        RmBand() {
            super("Remove Bands", 2);
            String[] list = NewTicketAuction.this.band.getList();
            for (int i = 0; i < list.length; ++i) {
                this.append(list[i], null);
            }
            this.addCommand(BACK_CMD);
            this.addCommand(SAVE_CMD);
            this.setCommandListener(this);
        }

        public void commandAction(Command c, Displayable s) {
            if (c == SAVE_CMD) {
                boolean[] ret = new boolean[this.size()];
                this.getSelectedFlags(ret);
                this.removeBandList(ret);
                NewTicketAuction.this.display.setCurrent(NewTicketAuction.this.savedMsg, (Displayable)NewTicketAuction.this.band_ticket_Form);
            } else if (c == BACK_CMD) {
                NewTicketAuction.this.display.setCurrent((Displayable)NewTicketAuction.this.band_ticket_Form);
            }
        }

        void reset() {
            NewTicketAuction.this.reconstructList((Choice)this, NewTicketAuction.this.band.getList());
        }

        void removeBandList(boolean[] t) {
            int i = t.length;
            while (--i >= 0) {
                if (!t[i]) continue;
                NewTicketAuction.this.band.remove(i);
            }
            NewTicketAuction.this.reconstructBandTicketForm(NewTicketAuction.this.band.getList());
            NewTicketAuction.this.reconstructList((Choice)this, NewTicketAuction.this.band.getList());
        }
    }

    class Band {
        private BandListTable table = new BandListTable();
        String def_ticker = "Ricky Martin 2 tix $90.00 2 tix $110.00 2 tix $200.00 Tina Turner 2 tix $65.00";
        String alt_ticker = "Alanis Morisette 2 tix $58.00 4 tix $115.00 Fiona Apple 2 tix $37.00";

        Band() {
            TicketItem t = new TicketItem("Alanis Morrisette", "18 & 19", "XF, Row 17", "Aug 23, 2002", "PacBell Stadium", "San Francisco, CA", "#7720", "2", "45.00", "69.00", "2.00", "3", "12:00 am on Aug 16, 2002");
            this.add(0, "Alanis Morrisette", t);
            t = new TicketItem("Envy", "10, 11, 12, 13", "F9, Row A", "Sep 7, 2002", "Civic Center", "Santa Cruz, CA", "4509", "4", "100.00", "101.00", "1.00", "1", "9:45 pm on Sep 1, 2002");
            this.add(1, "Envy", t);
            t = new TicketItem("Envy", "69 & 70", "PIT Row 1", "Aug 9, 2002", "Monterey Civic Ampitheatre", "Monterey, CA", "3058", "2", "9.00", "175.00", "2.50", "40", "9:00 pm on Aug 2, 2002");
            this.add(1, "Envy", t);
            t = new TicketItem("Envy", "5 & 6 & 7", "PIT Rw 11", "Aug 10, 2002", "Monterey Civic Ampitheatre", "Monterey, CA", "3541", "3", "28.00", "97.00", "1.00", "11", "11:15 pm on Aug 2, 2002");
            this.add(1, "Envy", t);
            t = new TicketItem("JawBreakers", "General Admission", "- NA -", "Aug 3, 2002", "Bottom of the Hill", "San Francisco, CA", "3489", "2", "30.00", "44.00", "2.00", "5", "11:30 pm on Jul 7, 2002");
            this.add(2, "JawBreakers", t);
            t = new TicketItem("Jets to Brazil", "General Admission", "- NA -", "Jul 19, 2001", "The Fillmore", "San Francisco, CA", "3861", "2", "55.00", "62.50", "2.50", "3", "6:30 pm on Jul 12, 2002");
            this.add(3, "Jets to Brazil", t);
            t = new TicketItem("Jets to Brazil", "4 & 6", "N2 Row 5", "Jul 18, 2002", "Mountain View Center for the Performing Arts", "Mountain View, CA", "9916", "2", "65.00", "200.00", "10.00", "12", "9:30 pm on Jul 10, 2002");
            this.add(3, "Jets to Brazil", t);
            t = new TicketItem("moby", "General Admission", "- NA -", "Aug 3, 2002", "Bottom of the Hill", "San Francisco", "1313", "2", "30.00", "37.00", "1.00", "7", "5:35 pm on Jul 27, 2002");
            this.add(4, "moby", t);
            t = new TicketItem("Nerf Herders", "N & O", "S, Row 14", "Aug 3, 2002", "3COM Park", "San Francisco, CA", "8120", "2", "80.00", "125.00", "2.00", "5", "11:30 am on Jul 7, 2002");
            this.add(5, "Nerf Herders", t);
            t = new TicketItem("The Mr. T Experience", "15 & 16", "B, Row 14", "Aug 30, 2002", "3COM Park", "San Francisco, CA", "1770", "2", "100.00", "175.00", "2.00", "5", "11:30 pm on Aug 23, 2002");
            this.add(6, "The Mr. T Experience", t);
            t = new TicketItem("Thirty Odd Foot of Grunts", "11 & 12", "F Row J", "Jul 19, 2001", "Stugg's Ampitheatre", "Austin, TX", "3766", "2", "60.00", "90.00", "5.00", "3", "6:30 pm on Jul 12, 2002");
            this.add(7, "Thirty Odd Foot of Grunts", t);
            t = new TicketItem("Thirty Odd Foot of Grunts", "4 & 6", "N2 Row 5", "Jul 18, 2002", "Seattle Thunderdome", "Seattle, WA", "9135", "2", "70.00", "200.00", "10.00", "12", "9:30 pm on Jul 10, 2002");
            this.add(7, "Thirty Odd Foot of Grunts", t);
            t = new TicketItem("Thirty Odd Foot of Grunts", "General Admission", "- NA -", "Jul 20, 2002", "The Fillmore", "San Francisco, CA", "2722", "2", "75.00", "110.00", "2.00", "12", "4:00 pm on Jul 13, 2002");
            this.add(7, "Thirty Odd Foot of Grunts", t);
        }

        void add(String bandName) {
            this.add(this.table.size(), bandName, new TicketItem(bandName));
        }

        void add(int i, String bandName) {
            this.add(i, bandName, new TicketItem(bandName));
        }

        void add(int i, String bandName, TicketItem item) {
            Object obj = this.table.get(bandName);
            Vector<TicketItem> vec = obj == null ? new Vector<TicketItem>() : (Vector)obj;
            vec.addElement(item);
            this.table.put(i, vec);
        }

        void remove(int i) {
            this.table.remove(i);
        }

        String[] getList() {
            int num = this.table.size();
            String[] seq = new String[num];
            for (int i = 0; i < num; ++i) {
                Vector vec = (Vector)this.table.elementAt(i);
                TicketItem item = (TicketItem)vec.elementAt(0);
                seq[i] = item.name;
            }
            return seq;
        }

        String getName(int nth) {
            TicketItem item;
            Vector vec = (Vector)this.table.elementAt(nth);
            if (vec != null && (item = (TicketItem)vec.elementAt(0)) != null) {
                return item.name;
            }
            return null;
        }

        String[] getTicketList(String bandName) {
            Object obj = this.table.get(bandName);
            if (obj == null) {
                return null;
            }
            Vector vec = (Vector)obj;
            int num = vec.size();
            String[] seq = new String[num];
            for (int i = 0; i < num; ++i) {
                TicketItem item = (TicketItem)vec.elementAt(i);
                seq[i] = new String("#" + item.id + " $" + item.curBid + "\n" + item.place + ", " + item.state + "\n" + item.sect + "," + item.seat + " ...");
            }
            return seq;
        }

        TicketItem getTicketItem(String bandName, int nth) {
            Object obj = this.table.get(bandName);
            if (obj == null) {
                return null;
            }
            Vector vec = (Vector)obj;
            return (TicketItem)vec.elementAt(nth);
        }

        String getTicketID(String bandName, int nth) {
            TicketItem item = this.getTicketItem(bandName, nth);
            if (item == null) {
                return null;
            }
            return item.id;
        }

        String getTicketDataTitle(String bandName, int nth) {
            TicketItem item = this.getTicketItem(bandName, nth);
            if (item == null) {
                return null;
            }
            return item.name + " " + item.id + ":";
        }

        void getTicketData(Form form, String bandName, int nth) {
            TicketItem item = this.getTicketItem(bandName, nth);
            if (item == null) {
                return;
            }
            form.append((Item)new StringItem("Quantity:", item.numItem + " tickets"));
            form.append((Item)new StringItem("Bid starts at:", "$" + item.begBid));
            form.append((Item)new StringItem("Current bid:", "$" + item.curBid));
            form.append((Item)new StringItem("Number of Bids:", item.numBids));
            form.append((Item)new StringItem("Bidding ends at:", item.endsAt));
            form.append((Item)new StringItem("Seat(s):", item.seat));
            form.append((Item)new StringItem("Concert Date:", item.date));
            form.append((Item)new StringItem("Concert Venue:", item.place + "," + item.state));
        }

        void getAuctionData(Form form, String bandName, int nth) {
            TicketItem item = this.getTicketItem(bandName, nth);
            if (item == null) {
                return;
            }
            form.append((Item)new StringItem("Band Name:", item.name + " tickets"));
            form.append((Item)new StringItem("Concert Date:", item.date));
            form.append((Item)new StringItem("Quantity:", item.numItem));
            form.append((Item)new StringItem("Concert Venue:", item.place + "," + item.state));
        }

        String getCurrentBid(String bandName, int nth) {
            TicketItem item = this.getTicketItem(bandName, nth);
            if (item == null) {
                return "";
            }
            return item.curBid;
        }

        boolean isTicketData(String bandName, String itemID) {
            return this.getTicketItem(bandName, itemID) != null;
        }

        TicketItem getTicketItem(String bandName, String itemID) {
            Object obj = this.table.get(bandName);
            if (obj == null) {
                return null;
            }
            Vector vec = (Vector)obj;
            int num = vec.size();
            for (int i = 0; i < num; ++i) {
                TicketItem item = (TicketItem)vec.elementAt(i);
                if (!item.id.equals(itemID)) continue;
                return item;
            }
            return null;
        }

        void getTicketBidTitle(Form f, String bandName, int itemID) {
            TicketItem item = this.getTicketItem(bandName, itemID);
            long min = this.stringToLong1000(item.curBid) + this.stringToLong1000(item.incBid);
            String minBid = this.long1000ToString(min);
            NewTicketAuction.this.login.curBid.setText("$" + item.curBid);
            NewTicketAuction.this.login.incBid.setText("$" + item.incBid);
            NewTicketAuction.this.login.minBid.setText("$" + minBid);
        }

        String toTickerString(boolean[] selected) {
            String s = "";
            if (selected == null) {
                return this.alt_ticker;
            }
            if (selected[0]) {
                s = s + this.def_ticker;
            }
            if (selected[1]) {
                // empty if block
            }
            if (selected[2]) {
                // empty if block
            }
            if (selected[3]) {
                if (s.length() > 0) {
                    s = s + " ";
                }
                s = s + this.alt_ticker;
            }
            if (selected[4]) {
                // empty if block
            }
            if (selected[5]) {
                // empty if block
            }
            return s;
        }

        long stringToLong1000(String s) {
            if (s == null || s.equals("")) {
                return 0L;
            }
            try {
                int index = s.indexOf(46);
                if (index == -1) {
                    return 1000L * (long)Integer.parseInt(s);
                }
                long integerPart = 1000 * Integer.parseInt(s.substring(0, index));
                String fracString = s.substring(index + 1);
                int multBy = 0;
                switch (fracString.length()) {
                    case 0: {
                        multBy = 0;
                        break;
                    }
                    case 1: {
                        multBy = 100;
                        break;
                    }
                    case 2: {
                        multBy = 10;
                        break;
                    }
                    case 3: {
                        multBy = 1;
                    }
                }
                long fractionalPart = multBy * Integer.parseInt(fracString);
                return integerPart + fractionalPart;
            }
            catch (NumberFormatException nfe) {
                return 0L;
            }
        }

        String long1000ToString(long l) {
            if (l == 0L) {
                return "0";
            }
            String s = String.valueOf(l);
            if (s.length() < 4) {
                return "0";
            }
            String newStr = s.substring(0, s.length() - 3) + "." + s.substring(s.length() - 2);
            return newStr;
        }

        class BandListTable {
            private Vector vec = new Vector();

            BandListTable() {
            }

            void put(int nth, Object obj) {
                Object o = null;
                try {
                    o = this.vec.elementAt(nth);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    o = null;
                }
                if (o == null) {
                    this.vec.addElement(obj);
                } else {
                    this.vec.setElementAt(obj, nth);
                }
            }

            Object get(String bandName) {
                int num = this.vec.size();
                for (int i = 0; i < num; ++i) {
                    Object obj = this.vec.elementAt(i);
                    if (!(obj instanceof Vector)) continue;
                    Vector v = (Vector)obj;
                    TicketItem item = (TicketItem)v.elementAt(0);
                    if (!item.name.equals(bandName)) continue;
                    return obj;
                }
                return null;
            }

            Object elementAt(int index) {
                return this.vec.elementAt(index);
            }

            void remove(int i) {
                Object o = null;
                try {
                    o = this.vec.elementAt(i);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    o = null;
                }
                if (o != null) {
                    this.vec.removeElementAt(i);
                }
            }

            int size() {
                return this.vec.size();
            }
        }

        class TicketItem {
            String name;
            String seat;
            String sect;
            String date;
            String place;
            String state;
            String id;
            String numItem;
            String begBid;
            String curBid;
            String incBid;
            String numBids;
            String endsAt;

            TicketItem(String name, String seat, String sect, String date, String place, String state, String id, String numItem, String begBid, String curBid, String incBid, String numBids, String endsAt) {
                this.name = name;
                this.seat = seat;
                this.sect = sect;
                this.date = date;
                this.place = place;
                this.state = state;
                this.id = id;
                this.numItem = numItem;
                this.begBid = begBid;
                this.curBid = curBid;
                this.incBid = incBid;
                this.numBids = numBids;
                this.endsAt = endsAt;
            }

            TicketItem(String name) {
                this(name, "n/a", "n/a", "n/a", "n/a", "n/a", "0", "0", "0", "0", "0", "0", "0");
            }
        }
    }

    class Login
    extends Form
    implements CommandListener {
        TextField id = new TextField("", "", 10, 0);
        TextField pd = new TextField("", "", 10, 65538);
        TextField bidText = new TextField("Enter Bid:", "", 10, 5);
        StringItem submitButton = new StringItem("", "Submit", 2);
        StringItem auctionHyperlink = new StringItem("Auction:", "", 1);
        StringItem curBid = new StringItem("Current Bid:", "");
        StringItem incBid = new StringItem("Increment:", "");
        StringItem minBid = new StringItem("Minimum Bid:", "");
        Form confirm = new Form("Confirm Bid");
        Form notice = new Form("Bid Received");
        Form auctionForm = new Form("dummy");
        Alert loginAlert = new Alert("Alert", "Your must enter your ID and password before you can proceed.", null, null);
        String bandName;
        String bid;
        String ticketID;
        String _bandName;
        int _bandIndex;

        Login() {
            super("Make A Bid");
            this.id.setLabel("Enter Auction ID:");
            this.append((Item)this.id);
            this.pd.setLabel("Enter PIN:");
            this.append((Item)this.pd);
            this.append((Item)this.curBid);
            this.append((Item)this.incBid);
            this.append((Item)this.minBid);
            this.append((Item)this.bidText);
            this.addCommand(BACK_CMD);
            this.addCommand(NEXT_CMD);
            this.setCommandListener(this);
            MyItemCommandListener icl = new MyItemCommandListener();
            this.confirm.append("dummy");
            this.confirm.addCommand(CANCEL_CMD);
            this.confirm.setCommandListener((CommandListener)this);
            this.auctionHyperlink.setDefaultCommand(AUCTION_CMD);
            this.auctionHyperlink.setItemCommandListener((ItemCommandListener)icl);
            this.submitButton.setDefaultCommand(SUBMIT_CMD);
            this.submitButton.setItemCommandListener((ItemCommandListener)icl);
            NewTicketAuction.this.deleteFormItem(this.notice);
            this.notice.append((Item)new StringItem("Your bid has been received:", ""));
            this.notice.append((Item)new StringItem("Confirm #:", "12-B455-31"));
            this.notice.addCommand(BAND_CMD);
            this.notice.setCommandListener((CommandListener)this);
            this.loginAlert.setTimeout(-2);
            this.auctionForm.append("dummy");
            this.auctionForm.addCommand(BACK_CMD);
            this.auctionForm.setCommandListener((CommandListener)this);
        }

        void setBid(String bandName, String bid) {
            this.bandName = bandName;
            this.bid = bid;
        }

        void setID(String bandName, String ticketID) {
            this.bandName = bandName;
            this.ticketID = ticketID;
        }

        void setBandAttributes(String bandName, int bandIndex) {
            this._bandName = bandName;
            this._bandIndex = bandIndex;
        }

        void doSubmit() {
            NewTicketAuction.this.TimerService = new Timer();
            TimerClient timerClient = new TimerClient();
            NewTicketAuction.this.TimerService.schedule((TimerTask)timerClient, 0L, 1000L);
            NewTicketAuction.this.display.setCurrent((Displayable)NewTicketAuction.this.submitMsg);
        }

        public void commandAction(Command c, Displayable s) {
            if (s instanceof Form) {
                Form obj = (Form)s;
                if (obj == this) {
                    if (c == BACK_CMD) {
                        NewTicketAuction.this.display.setCurrent((Displayable)NewTicketAuction.this.band_ticket_Form);
                    } else if (c == NEXT_CMD) {
                        if (this.id.getString().length() == 0 || this.pd.getString().length() == 0) {
                            NewTicketAuction.this.display.setCurrent((Displayable)this.loginAlert);
                        } else {
                            NewTicketAuction.this.login.setID(this._bandName, NewTicketAuction.this.band.getTicketID(this._bandName, this._bandIndex));
                            String bidAmt = this.bidText.getString();
                            System.err.println("\n\n #### bidAmt : " + bidAmt);
                            if (bidAmt.equals("")) {
                                Alert errorAlert = new Alert("Alert", "The bid amount you have entered is invalid.", null, AlertType.ERROR);
                                errorAlert.setTimeout(-2);
                                NewTicketAuction.this.display.setCurrent((Displayable)errorAlert);
                            } else {
                                NewTicketAuction.this.deleteFormItem(NewTicketAuction.this.login.confirm);
                                NewTicketAuction.this.login.confirm.append((Item)new StringItem("Please confirm this information is correct before submitting your bid", ""));
                                this.auctionHyperlink.setText(NewTicketAuction.this.login.ticketID);
                                NewTicketAuction.this.login.confirm.append((Item)this.auctionHyperlink);
                                NewTicketAuction.this.login.confirm.append((Item)new StringItem("Band: " + NewTicketAuction.this.login.bandName, ""));
                                NewTicketAuction.this.login.confirm.append((Item)new StringItem("Bid Amount:", "$" + bidAmt));
                                NewTicketAuction.this.login.confirm.append((Item)this.submitButton);
                                NewTicketAuction.this.display.setCurrent((Displayable)NewTicketAuction.this.login.confirm);
                            }
                        }
                    }
                } else if (obj == this.confirm) {
                    if (c == CANCEL_CMD) {
                        NewTicketAuction.this.display.setCurrent((Displayable)this);
                    }
                } else if (obj == this.notice) {
                    if (c == BAND_CMD) {
                        NewTicketAuction.this.display.setCurrent((Displayable)NewTicketAuction.this.band_ticket_Form);
                    }
                } else if (obj == this.auctionForm && c == BACK_CMD) {
                    NewTicketAuction.this.display.setCurrent((Displayable)this.confirm);
                }
            }
        }

        private class TimerClient
        extends TimerTask {
            private TimerClient() {
            }

            public final void run() {
                if (((Login)Login.this).NewTicketAuction.this.submitGauge.getValue() == ((Login)Login.this).NewTicketAuction.this.submitGauge.getMaxValue()) {
                    ((Login)Login.this).NewTicketAuction.this.TimerService.cancel();
                    ((Login)Login.this).NewTicketAuction.this.submitGauge.setValue(0);
                    ((Login)Login.this).NewTicketAuction.this.display.setCurrent((Displayable)Login.this.notice);
                } else {
                    ((Login)Login.this).NewTicketAuction.this.submitGauge.setValue(((Login)Login.this).NewTicketAuction.this.submitGauge.getValue() + 10);
                }
            }
        }

        class MyItemCommandListener
        implements ItemCommandListener {
            MyItemCommandListener() {
            }

            public void commandAction(Command c, Item item) {
                if (c == SUBMIT_CMD) {
                    Login.this.doSubmit();
                } else if (c == AUCTION_CMD) {
                    NewTicketAuction.this.deleteFormItem(Login.this.auctionForm);
                    Login.this.auctionForm.setTitle("Auction:" + ((Login)Login.this).NewTicketAuction.this.login.ticketID);
                    ((Login)Login.this).NewTicketAuction.this.band.getAuctionData(Login.this.auctionForm, ((Login)Login.this).NewTicketAuction.this.login.bandName, ((Login)Login.this).NewTicketAuction.this.login._bandIndex);
                    ((Login)Login.this).NewTicketAuction.this.display.setCurrent((Displayable)Login.this.auctionForm);
                }
            }
        }
    }
}

