/*
 * Decompiled with CFR 0.152.
 */
package example.http2;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.ContentConnection;
import javax.microedition.io.HttpConnection;
import javax.microedition.io.StreamConnection;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Item;
import javax.microedition.midlet.MIDlet;

public class HttpExample
extends MIDlet
implements Runnable {
    String url = "http://www.yahoo.com/";
    StringBuffer buffer = new StringBuffer();
    Gauge gauge = new Gauge("Progress", false, 10, 0);
    Form form = new Form("Progress");

    public HttpExample() {
        this.form.append((Item)this.gauge);
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.form);
    }

    public void startApp() {
        new Thread(this).start();
    }

    public void run() {
        try {
            this.gauge.setLabel("Get using ContentConnection");
            this.gauge.setValue(2);
            this.getViaContentConnection(this.url);
            this.gauge.setLabel("Get using StreamConnection");
            this.gauge.setValue(4);
            this.getViaStreamConnection(this.url);
            this.gauge.setLabel("Get using HttpConnection");
            this.gauge.setValue(6);
            this.getViaHttpConnection(this.url);
            this.gauge.setLabel("Post using HttpConnection");
            this.gauge.setValue(8);
            this.postViaHttpConnection(this.url);
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
        }
        this.gauge.setValue(10);
        this.notifyDestroyed();
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean unconditional) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getViaStreamConnection(String url) throws IOException {
        StreamConnection c = null;
        InputStream s = null;
        try {
            int ch;
            c = (StreamConnection)Connector.open((String)url);
            s = c.openInputStream();
            this.buffer.setLength(0);
            while ((ch = s.read()) != -1) {
                this.process((byte)ch);
            }
        }
        finally {
            if (s != null) {
                s.close();
            }
            if (c != null) {
                c.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getViaContentConnection(String url) throws IOException {
        ContentConnection c = null;
        InputStream is = null;
        try {
            c = (ContentConnection)Connector.open((String)url);
            is = c.openInputStream();
            this.buffer.setLength(0);
            int len = (int)c.getLength();
            if (len > 0) {
                byte[] data = new byte[len];
                int actual = is.read(data);
                this.process(data);
            } else {
                int ch;
                while ((ch = is.read()) != -1) {
                    this.process((byte)ch);
                }
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (c != null) {
                c.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getViaHttpConnection(String url) throws IOException {
        HttpConnection c = null;
        InputStream is = null;
        OutputStream os = null;
        try {
            int status = -1;
            while (true) {
                c = (HttpConnection)Connector.open((String)url);
                this.setRequestHeaders(c);
                status = c.getResponseCode();
                if (status != 307 && status != 302 && status != 301) break;
                url = c.getHeaderField("location");
                c.close();
                System.out.println("Redirecting to " + url);
            }
            if (status == 501 || status == 505 || status == 500 || status == 504 || status == 502) {
                System.err.print("WARNING: Server error status [" + status + "] ");
                System.err.println("returned for url [" + url + "]");
                if (is != null) {
                    is.close();
                }
                if (os != null) {
                    os.close();
                }
                if (c != null) {
                    c.close();
                }
                return;
            }
            if (status != 200) {
                throw new IOException("Response status not OK [" + status + "]");
            }
            String type = c.getType();
            this.processType(type);
            is = c.openInputStream();
            this.buffer.setLength(0);
            int len = (int)c.getLength();
            if (len > 0) {
                byte[] data = new byte[len];
                int actual = is.read(data);
                this.process(data);
            } else {
                int ch;
                while ((ch = is.read()) != -1) {
                    this.process((byte)ch);
                }
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (c != null) {
                c.close();
            }
        }
    }

    void setRequestHeaders(HttpConnection c) throws IOException {
        String conf = System.getProperty("microedition.configuration");
        String prof = System.getProperty("microedition.profiles");
        int space = prof.indexOf(32);
        if (space != -1) {
            prof = prof.substring(0, space - 1);
        }
        String locale = System.getProperty("microedition.locale");
        String ua = "Profile/" + prof + " Configuration/" + conf;
        c.setRequestProperty("User-Agent", ua);
        if (locale != null) {
            c.setRequestProperty("Content-Language", locale);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void postViaHttpConnection(String url) throws IOException {
        int status = 0;
        HttpConnection c = null;
        InputStream is = null;
        OutputStream os = null;
        try {
            c = (HttpConnection)Connector.open((String)url);
            c.setRequestMethod("POST");
            c.setRequestProperty("If-Modified-Since", "29 Oct 1999 19:43:31 GMT");
            c.setRequestProperty("User-Agent", "Profile/MIDP-1.0 Configuration/CLDC-1.0");
            c.setRequestProperty("Content-Language", "en-US");
            os = c.openOutputStream();
            os.write("LIST games\n".getBytes());
            os.flush();
            status = c.getResponseCode();
            if (status == 501 || status == 505 || status == 500 || status == 504 || status == 502) {
                System.err.print("WARNING: Server error status [" + status + "] ");
                System.err.println("returned for url [" + url + "]");
                if (is != null) {
                    is.close();
                }
                if (os != null) {
                    os.close();
                }
                if (c != null) {
                    c.close();
                }
                return;
            }
            if (status != 200) {
                throw new IOException("Response status not OK [" + status + "]");
            }
            is = c.openInputStream();
            String type = c.getType();
            this.processType(type);
            int len = (int)c.getLength();
            if (len > 0) {
                byte[] data = new byte[len];
                int actual = is.read(data);
                this.process(data);
            } else {
                int ch;
                while ((ch = is.read()) != -1) {
                    this.process((byte)ch);
                }
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (os != null) {
                os.close();
            }
            if (c != null) {
                c.close();
            }
        }
    }

    void processType(String type) {
    }

    void process(byte b) {
        this.buffer.append((char)b);
    }

    void process(byte[] b) {
        for (int i = 0; i < b.length; ++i) {
            this.process(b[i]);
        }
    }
}

