/*
 * Decompiled with CFR 0.152.
 */
package example.http2;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.Vector;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.io.HttpsConnection;
import javax.microedition.io.SecurityInfo;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.TextBox;
import javax.microedition.midlet.MIDlet;
import javax.microedition.pki.Certificate;
import javax.microedition.pki.CertificateException;

public class HttpTest
extends MIDlet
implements CommandListener,
Runnable {
    private Command exitCommand = new Command("Exit", 7, 2);
    private Command getCommand = new Command("Get", 1, 1);
    private Command postCommand = new Command("Post", 1, 1);
    private Command headCommand = new Command("Head", 1, 1);
    private Command chooseCommand = new Command("Choose", 1, 2);
    private Command addCommand = new Command("Add", 1, 1);
    private Command addSaveCommand = new Command("OK", 1, 1);
    private Command okCommand = new Command("OK", 4, 1);
    private Command cancelCommand = new Command("Cancel", 3, 1);
    private Display display;
    private String url;
    private Vector urls = new Vector();
    private List list;
    private TextBox addTextBox;
    private Command currentCommand;
    private Thread commandThread;
    private int attempt;
    private TextBox t;
    private boolean firstTime;

    public HttpTest() {
        this.urls.addElement("http://www.yahoo.com/");
        this.urls.addElement("http://www.sun.com/");
        this.urls.addElement("https://central.sun.net/");
        this.urls.addElement("https://www.wellsfargo.com");
        this.urls.addElement("-----------------------");
        this.urls.addElement("http://jse.east/Telco/HttpTest.txt");
        this.urls.addElement("http://spiro.eng/");
        this.urls.addElement("http://spiro.eng:80/");
        this.urls.addElement("http://localhost:8080/");
        this.urls.addElement("-----------------------");
        this.urls.addElement("shttp://host/notsupportedprotocol");
        this.urls.addElement("http://:8080/missinghost");
        this.urls.addElement("http://mal\\formed:axyt/url???");
        this.urls.addElement("http://www.yahoo.com/no/such/page/");
        this.urls.addElement("http://www.yahoo.com:29999/no/such/port/");
        this.urls.addElement("http://no.such.site/");
        this.urls.addElement("http://www.yahoo.com/bad_proxy/");
        this.url = (String)this.urls.elementAt(0);
        this.display = Display.getDisplay((MIDlet)this);
        this.firstTime = true;
    }

    static final void DEBUG(String s) {
        System.out.println(s);
    }

    private String time2str(long time) {
        Calendar c = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        c.setTime(new Date(time));
        return ((Object)c).toString();
    }

    public void startApp() {
        if (this.firstTime) {
            String u = this.getAppProperty("HttpTest-Url");
            if (u != null) {
                this.url = u;
            }
            this.mainScreen();
            this.firstTime = false;
        } else {
            this.display.setCurrent((Displayable)this.t);
        }
    }

    void mainScreen() {
        String s = "URL = " + this.url + ". Press Get or Post to fetch it, or Choose to " + "use another URL";
        this.t = new TextBox("Http Test", s, s.length(), 0);
        this.setCommands((Displayable)this.t, false);
        this.display.setCurrent((Displayable)this.t);
    }

    void chooseScreen() {
        this.list = new List("Choose URL", 1);
        for (int i = 0; i < this.urls.size(); ++i) {
            this.list.append((String)this.urls.elementAt(i), null);
        }
        this.setCommands((Displayable)this.list, true);
        this.display.setCurrent((Displayable)this.list);
    }

    void addScreen() {
        this.addTextBox = new TextBox("New URL", "http://", 200, 0);
        this.addTextBox.addCommand(this.addSaveCommand);
        this.addTextBox.addCommand(this.cancelCommand);
        this.addTextBox.setCommandListener((CommandListener)this);
        this.display.setCurrent((Displayable)this.addTextBox);
    }

    private void readContents(String request) {
        StringBuffer b = new StringBuffer();
        ++this.attempt;
        b.append("attempt " + this.attempt + " content of " + request + " " + this.url + "\n");
        HttpConnection c = null;
        OutputStream os = null;
        InputStream is = null;
        TextBox t = null;
        try {
            int rc;
            long len = -1L;
            int ch = 0;
            long count = 0L;
            HttpTest.DEBUG(request + " Page: " + this.url);
            c = (HttpConnection)Connector.open((String)this.url);
            HttpTest.DEBUG("c= " + c);
            c.setRequestMethod(request);
            c.setRequestProperty("foldedField", "first line\r\n second line\r\n third line");
            if (request == "POST") {
                String m = "Test POST text.";
                HttpTest.DEBUG("Posting: " + m);
                os = c.openOutputStream();
                os.write(m.getBytes());
                os.close();
            }
            if ((rc = c.getResponseCode()) != 200) {
                b.append("Response Code: " + c.getResponseCode() + "\n");
                b.append("Response Message: " + c.getResponseMessage() + "\n\n");
            }
            is = c.openInputStream();
            HttpTest.DEBUG("is = " + is);
            if (c instanceof HttpConnection) {
                len = c.getLength();
            }
            HttpTest.DEBUG("len = " + len);
            if (len != -1L) {
                HttpTest.DEBUG("Content-Length: " + len);
                int i = 0;
                while ((long)i < len) {
                    ch = is.read();
                    if (ch != -1) {
                        if (ch <= 32) {
                            ch = 32;
                        }
                        b.append((char)ch);
                        if (++count > 200L) break;
                    }
                    ++i;
                }
            } else {
                byte[] data = new byte[100];
                int n = is.read(data, 0, data.length);
                for (int i = 0; i < n; ++i) {
                    ch = data[i] & 0xFF;
                    b.append((char)ch);
                }
            }
            try {
                if (is != null) {
                    is.close();
                }
                if (c != null) {
                    c.close();
                }
            }
            catch (Exception ce) {
                HttpTest.DEBUG("Error closing connection");
            }
            try {
                len = is.available();
                HttpTest.DEBUG("Inputstream failed to throw IOException after close");
            }
            catch (IOException io) {
                HttpTest.DEBUG("expected IOException (available())");
                io.printStackTrace();
            }
            t = new TextBox("Http Test", b.toString(), b.length(), 0);
            is = null;
            c = null;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            HttpTest.DEBUG(ex.getClass().toString());
            HttpTest.DEBUG(ex.toString());
            HttpTest.DEBUG("Exception reading from http");
            if (c != null) {
                try {
                    String s = null;
                    if (c instanceof HttpConnection) {
                        s = c.getResponseMessage();
                    }
                    HttpTest.DEBUG(s);
                    if (s == null) {
                        s = "No Response message";
                    }
                    t = new TextBox("Http Error", s, s.length(), 0);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    String s = e.toString();
                    HttpTest.DEBUG(s);
                    if (s == null) {
                        s = ex.getClass().getName();
                    }
                    t = new TextBox("Http Error", s, s.length(), 0);
                }
                try {
                    c.close();
                }
                catch (IOException ioe) {}
            }
            t = new TextBox("Http Error", "Could not open URL", 128, 0);
        }
        catch (IllegalArgumentException ille) {
            t = new TextBox("Illegal Argument", ille.getMessage(), 128, 0);
        }
        if (is != null) {
            try {
                is.close();
            }
            catch (Exception ce) {
                // empty catch block
            }
        }
        if (c != null) {
            try {
                c.close();
            }
            catch (Exception ce) {
                // empty catch block
            }
        }
        this.setCommands((Displayable)t, false);
        this.display.setCurrent((Displayable)t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readHeaders(String request) {
        try {
            HttpConnection c;
            try {
                c = (HttpConnection)Connector.open((String)this.url);
            }
            catch (IllegalArgumentException e) {
                String m = e.getMessage();
                TextBox t = new TextBox("Illegal argument", e.getMessage(), 128, 0);
                this.setCommands((Displayable)t, false);
                this.display.setCurrent((Displayable)t);
                return;
            }
            catch (ConnectionNotFoundException e) {
                TextBox t = new TextBox("Error", "Protocol not supported", 128, 0);
                this.setCommands((Displayable)t, false);
                this.display.setCurrent((Displayable)t);
                return;
            }
            try {
                c.setRequestMethod(request);
                StringBuffer b = new StringBuffer();
                b.append("URL: ");
                b.append(c.getURL());
                b.append("\nProtocol: ");
                b.append(c.getProtocol());
                b.append("\nHost: " + c.getHost());
                b.append("\nFile: " + c.getFile());
                b.append("\nRef: " + c.getRef());
                b.append("\nQuery: ");
                b.append(c.getQuery());
                b.append("\nPort: ");
                b.append(c.getPort());
                b.append("\nMethod: ");
                b.append(c.getRequestMethod());
                if (c instanceof HttpsConnection) {
                    SecurityInfo sslInfo = ((HttpsConnection)c).getSecurityInfo();
                    Certificate cert = sslInfo.getServerCertificate();
                    b.append("\nSecure protocol: ");
                    b.append(sslInfo.getProtocolName());
                    b.append("\nSecure protocol version: ");
                    b.append(sslInfo.getProtocolVersion());
                    b.append("\nCipher suite: ");
                    b.append(sslInfo.getCipherSuite());
                    if (cert == null) {
                        b.append("\nNo server Certficate.");
                    } else {
                        b.append("\nServer certificate \n\t Type: ");
                        b.append(cert.getType());
                        b.append("\n\t Version: ");
                        b.append(cert.getVersion());
                        b.append("\n\t Serial number: ");
                        b.append(cert.getSerialNumber());
                        b.append("\n\t Issuer: ");
                        b.append(cert.getIssuer());
                        b.append("\n\t Subject: ");
                        b.append(cert.getSubject());
                        b.append("\n\t Signature algorithm: ");
                        b.append(cert.getSigAlgName());
                        b.append("\n\t Not valid before: ");
                        b.append(this.time2str(cert.getNotBefore()));
                        b.append("\n\t Not valid after:  ");
                        b.append(this.time2str(cert.getNotAfter()));
                    }
                }
                b.append("\nResponseCode: ");
                b.append(c.getResponseCode());
                b.append("\nResponseMessage:");
                b.append(c.getResponseMessage());
                b.append("\nContentLength: ");
                b.append(c.getLength());
                b.append("\nContentType: ");
                b.append(c.getType());
                b.append("\nContentEncoding: ");
                b.append(c.getEncoding());
                b.append("\nContentExpiration: ");
                b.append(c.getExpiration());
                b.append("\nDate: ");
                b.append(c.getDate());
                b.append("\nLast-Modified: ");
                b.append(c.getLastModified());
                b.append("\n\n");
                int h = 0;
                try {
                    String key;
                    while ((key = c.getHeaderFieldKey(h)) != null) {
                        String value = c.getHeaderField(h);
                        b.append(key);
                        b.append(": ");
                        b.append(value);
                        b.append("\n");
                        ++h;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                TextBox t = new TextBox("Http Test", b.toString(), b.length(), 0);
                this.setCommands((Displayable)t, false);
                this.display.setCurrent((Displayable)t);
            }
            finally {
                c.close();
            }
        }
        catch (ConnectionNotFoundException e) {
            TextBox t = new TextBox("Error", "Could not Connect.", 128, 0);
            this.setCommands((Displayable)t, false);
            this.display.setCurrent((Displayable)t);
            return;
        }
        catch (CertificateException e) {
            StringBuffer m = new StringBuffer(256);
            Certificate cert = e.getCertificate();
            m.append(e.getMessage());
            if (cert != null) {
                m.append("\nServer certificate \n\t Type: ");
                m.append(cert.getType());
                m.append("\n\t Version: ");
                m.append(cert.getVersion());
                m.append("\n\t Serial number: ");
                m.append(cert.getSerialNumber());
                m.append("\n\t Issuer: ");
                m.append(cert.getIssuer());
                m.append("\n\t Subject: ");
                m.append(cert.getSubject());
                m.append("\n\t Signature algorithm: ");
                m.append(cert.getSigAlgName());
                m.append("\n\t Not valid before: ");
                m.append(this.time2str(cert.getNotBefore()));
                m.append("\n\t Not valid after:  ");
                m.append(this.time2str(cert.getNotAfter()));
            }
            String s = m.toString();
            TextBox t = new TextBox("Certificate Error", s, s.length(), 0);
            this.setCommands((Displayable)t, false);
            this.display.setCurrent((Displayable)t);
            return;
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    void setCommands(Displayable d, boolean islist) {
        if (islist) {
            d.addCommand(this.addCommand);
            d.addCommand(this.okCommand);
        } else {
            d.addCommand(this.exitCommand);
            d.addCommand(this.chooseCommand);
            d.addCommand(this.getCommand);
            d.addCommand(this.postCommand);
            d.addCommand(this.headCommand);
        }
        d.setCommandListener((CommandListener)this);
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean unconditional) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commandAction(Command c, Displayable s) {
        HttpTest httpTest = this;
        synchronized (httpTest) {
            if (this.commandThread != null) {
                return;
            }
            this.currentCommand = c;
            this.commandThread = new Thread(this);
            this.commandThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.currentCommand == this.exitCommand) {
            this.destroyApp(false);
            this.notifyDestroyed();
        } else if (this.currentCommand == this.getCommand) {
            this.readContents("GET");
        } else if (this.currentCommand == this.postCommand) {
            this.readContents("POST");
        } else if (this.currentCommand == this.headCommand) {
            this.readHeaders("HEAD");
        } else if (this.currentCommand == this.chooseCommand) {
            this.chooseScreen();
        } else if (this.currentCommand == this.okCommand) {
            int i = this.list.getSelectedIndex();
            if (i >= 0) {
                this.url = this.list.getString(i);
            }
            this.mainScreen();
        } else if (this.currentCommand == this.addSaveCommand) {
            this.urls.addElement(this.addTextBox.getString().trim());
            this.chooseScreen();
        } else if (this.currentCommand == this.addCommand) {
            this.addScreen();
        } else if (this.currentCommand == this.cancelCommand) {
            this.chooseScreen();
        }
        HttpTest httpTest = this;
        synchronized (httpTest) {
            this.commandThread = null;
        }
    }
}

