/*
 * Decompiled with CFR 0.152.
 */
package example.http2;

import example.About;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Vector;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.io.Connector;
import javax.microedition.io.Datagram;
import javax.microedition.io.HttpConnection;
import javax.microedition.io.PushRegistry;
import javax.microedition.io.ServerSocketConnection;
import javax.microedition.io.SocketConnection;
import javax.microedition.io.UDPDatagramConnection;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.Screen;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextBox;
import javax.microedition.midlet.MIDlet;

public class HttpView
extends MIDlet
implements CommandListener,
Runnable {
    Command exitCommand = new Command("Exit", 7, 2);
    Command reloadCommand = new Command("Reload", 1, 1);
    Command headCommand = new Command("Head", 1, 1);
    Command postCommand = new Command("Post", 1, 1);
    Command getCommand = new Command("Get", 1, 1);
    Command aboutCommand = new Command("About", 5, 1);
    Command cancelCommand = new Command("Cancel", 1, 1);
    Command backCommand = new Command("Back", 2, 1);
    Command headersCommand = new Command("Headers", 1, 1);
    Command requestsCommand = new Command("Requests", 1, 1);
    Command errorsCommand = new Command("Errors", 1, 1);
    Command newURLCommand = new Command("New URL", 1, 10);
    Command removeURLCommand = new Command("Remove", 1, 11);
    Command okCommand = new Command("Ok", 1, 1);
    Command helpCommand = new Command("Help", 5, 1);
    List urlList;
    Vector urls;
    Alert alert;
    TextBox content;
    Display display = Display.getDisplay((MIDlet)this);
    Thread thread;
    String url;
    Command requestCommand;
    Form progressForm;
    Gauge progressGauge;
    Form headerForm;
    Form requestForm;
    Form errorsForm;
    TextBox urlbox;

    public HttpView() {
        this.setupList();
        this.alert = new Alert("Warning");
        this.alert.setTimeout(2000);
        this.headerForm = new Form("Headers");
        this.headerForm.addCommand(this.backCommand);
        this.headerForm.addCommand(this.requestsCommand);
        this.headerForm.setCommandListener((CommandListener)this);
        this.requestForm = new Form("Request headers");
        this.requestForm.addCommand(this.backCommand);
        this.requestForm.addCommand(this.errorsCommand);
        this.requestForm.setCommandListener((CommandListener)this);
        this.progressForm = new Form("Progress");
        this.progressForm.addCommand(this.cancelCommand);
        this.progressForm.setCommandListener((CommandListener)this);
        this.progressGauge = new Gauge(this.url, false, 9, 0);
        this.progressForm.append((Item)this.progressGauge);
        this.errorsForm = new Form("Errors");
        this.errorsForm.addCommand(this.backCommand);
        this.errorsForm.addCommand(this.headersCommand);
        this.errorsForm.setCommandListener((CommandListener)this);
        this.urlbox = new TextBox("Enter Url", "http://", 400, 4);
        this.urlbox.addCommand(this.okCommand);
        this.urlbox.setCommandListener((CommandListener)this);
    }

    public void startApp() {
        String[] connections = PushRegistry.listConnections((boolean)true);
        String pushProperty = this.getAppProperty("MIDlet-Push-1");
        if (connections != null && connections.length > 0) {
            String newurl = "Pushed URL Placeholder";
            try {
                String midlet = PushRegistry.getMIDlet((String)connections[0]);
                String filter = PushRegistry.getFilter((String)connections[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (connections[0].startsWith("socket://")) {
                try {
                    ServerSocketConnection scn = (ServerSocketConnection)Connector.open((String)connections[0]);
                    SocketConnection sc = (SocketConnection)scn.acceptAndOpen();
                    DataInputStream dis = sc.openDataInputStream();
                    byte[] buf = new byte[256];
                    int endofline = 0;
                    int count = dis.read(buf);
                    for (int i = 0; i < count; ++i) {
                        if (buf[i] != 10) continue;
                        endofline = i;
                        break;
                    }
                    newurl = new String(buf, 0, endofline);
                    dis.close();
                    sc.close();
                    scn.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                try {
                    PushRegistry.registerConnection((String)"datagram://:40080", (String)"example.http2.HttpView", (String)"129.148.*.*");
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (ConnectionNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else if (connections[0].startsWith("datagram://")) {
                try {
                    UDPDatagramConnection udc = (UDPDatagramConnection)Connector.open((String)connections[0]);
                    Datagram dg = udc.newDatagram(256);
                    udc.receive(dg);
                    udc.close();
                    byte[] buf = dg.getData();
                    int endofline = 0;
                    int count = buf.length;
                    for (int i = 0; i < count; ++i) {
                        if (buf[i] != 10) continue;
                        endofline = i;
                        break;
                    }
                    newurl = new String(buf, 0, endofline);
                    PushRegistry.unregisterConnection((String)"datagram://:40080");
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this.urlList.append(newurl, null);
            this.urls.addElement(newurl);
        } else {
            connections = PushRegistry.listConnections((boolean)false);
            try {
                Date alarm = new Date();
                PushRegistry.registerAlarm((String)"example.http2.HttpView", (long)(alarm.getTime() + 60000L));
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (ConnectionNotFoundException e) {
                e.printStackTrace();
            }
        }
        if (this.urlList.size() > 0) {
            this.display.setCurrent((Displayable)this.urlList);
        } else {
            this.alert.setString("No url's configured.");
            this.display.setCurrent(this.alert, (Displayable)this.urlList);
        }
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean unconditional) {
        this.thread = null;
    }

    void setupList() {
        String nthURL;
        String url;
        this.urls = new Vector();
        this.urlList = new List("URLs", 3);
        this.urlList.addCommand(this.headCommand);
        this.urlList.addCommand(this.getCommand);
        this.urlList.addCommand(this.postCommand);
        this.urlList.addCommand(this.exitCommand);
        this.urlList.addCommand(this.newURLCommand);
        this.urlList.addCommand(this.removeURLCommand);
        this.urlList.addCommand(this.helpCommand);
        this.urlList.setCommandListener((CommandListener)this);
        for (int n = 1; n < 100 && (url = this.getAppProperty(nthURL = "ViewURL-" + n)) != null && url.length() != 0; ++n) {
            String nthTitle = "ViewTitle-" + n;
            String title = this.getAppProperty(nthTitle);
            if (title == null || title.length() == 0) {
                title = url;
            }
            this.urls.addElement(url);
            this.urlList.append(title, null);
        }
        this.urls.addElement("http://jse.east/Telco/HttpTest.txt");
        this.urlList.append("Test URL", null);
    }

    public void commandAction(Command c, Displayable s) {
        try {
            if (c == this.exitCommand) {
                this.destroyApp(false);
                this.notifyDestroyed();
            } else if (c == this.headCommand || c == this.getCommand || c == this.postCommand || c == List.SELECT_COMMAND) {
                if (c == List.SELECT_COMMAND) {
                    c = this.getCommand;
                }
                this.requestCommand = c;
                int i = this.urlList.getSelectedIndex();
                this.url = (String)this.urls.elementAt(i);
                this.genProgressForm("Progress", this.url);
                this.display.setCurrent((Displayable)this.progressForm);
                this.thread = new Thread(this);
                this.thread.start();
            } else if (c == this.headersCommand) {
                this.display.setCurrent((Displayable)this.headerForm);
            } else if (c == this.requestsCommand) {
                this.display.setCurrent((Displayable)this.requestForm);
            } else if (c == this.errorsCommand) {
                this.display.setCurrent((Displayable)this.errorsForm);
            } else if (c == this.backCommand) {
                if (s == this.headerForm || s == this.requestForm || s == this.errorsForm) {
                    this.display.setCurrent((Displayable)this.content);
                } else {
                    this.display.setCurrent((Displayable)this.urlList);
                }
            } else if (c == this.cancelCommand) {
                this.thread = null;
                this.alert.setString("Loading cancelled.");
                this.display.setCurrent(this.alert, (Displayable)this.urlList);
            } else if (c == this.aboutCommand) {
                About.showAbout(this.display);
            } else if (c == this.newURLCommand) {
                this.display.setCurrent((Displayable)this.urlbox);
            } else if (c == this.removeURLCommand) {
                int i = this.urlList.getSelectedIndex();
                this.urlList.delete(i);
                this.urls.removeElementAt(i);
            } else if (c == this.okCommand && s == this.urlbox) {
                String newurl = this.urlbox.getString();
                this.urlList.append(newurl, null);
                this.urls.addElement(newurl);
                this.display.setCurrent((Displayable)this.urlList);
            } else if (c == this.helpCommand) {
                String helpString = "Use Head, Get or Post to download a URL.\n\nUse 'New URL' to enter a new URL.";
                Alert alert = new Alert(null, helpString, null, null);
                alert.setTimeout(-2);
                this.display.setCurrent((Displayable)alert);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        OutputStream output;
        InputStream input;
        HttpConnection conn;
        Thread mythread;
        block39: {
            block38: {
                block36: {
                    block35: {
                        block34: {
                            StringBuffer b;
                            long start = 0L;
                            long end = 0L;
                            boolean bytecode_count_start = false;
                            boolean bytecode_count_end = false;
                            mythread = Thread.currentThread();
                            String method = "GET";
                            if (this.requestCommand == this.headCommand) {
                                method = "HEAD";
                            } else if (this.requestCommand == this.postCommand) {
                                method = "POST";
                            }
                            if (this.content == null) {
                                this.content = new TextBox("Content", "", 4096, 0);
                                this.content.addCommand(this.backCommand);
                                this.content.addCommand(this.headersCommand);
                                this.content.setCommandListener((CommandListener)this);
                            }
                            this.content.setTitle("Body len = 0");
                            this.content.setString("");
                            this.genErrorsForm("Errors", null);
                            this.clearForm(this.requestForm);
                            this.clearForm(this.headerForm);
                            this.progressGauge.setValue(1);
                            conn = null;
                            input = null;
                            output = null;
                            String string = null;
                            try {
                                long len = 0L;
                                conn = (HttpConnection)Connector.open((String)this.url);
                                conn.setRequestMethod(method);
                                this.setConfig(conn);
                                if (mythread != this.thread) {
                                    return;
                                }
                                this.progressGauge.setValue(2);
                                for (int hops = 0; hops < 2; ++hops) {
                                    HttpConnection newConn;
                                    if (method == "POST") {
                                        output = conn.openOutputStream();
                                        if (mythread != this.thread) {
                                            this.cleanUp(conn, input, output);
                                            if (mythread != this.thread) return;
                                            break block34;
                                        }
                                        output.write("hello midlet world".getBytes());
                                        output.close();
                                        output = null;
                                    }
                                    if (conn == (newConn = this.handleRedirects(conn))) break;
                                    conn = newConn;
                                }
                                this.genRequestForm(conn);
                                input = conn.openInputStream();
                                if (mythread != this.thread) {
                                    this.cleanUp(conn, input, output);
                                    break block35;
                                }
                                this.content.setTitle(conn.getResponseMessage() + " (" + conn.getResponseCode() + ")");
                                this.genHeaderForm(conn);
                                this.progressGauge.setValue(5);
                                if (mythread != this.thread) {
                                    this.cleanUp(conn, input, output);
                                    break block36;
                                }
                                len = conn.getLength();
                                b = new StringBuffer(len >= 0L ? (int)len : 1000);
                                int max = this.content.getMaxSize();
                                if (len != -1L) {
                                    int ch = 0;
                                    int i = 0;
                                    while ((long)i < len) {
                                        ch = input.read();
                                        if (ch != -1) {
                                            if (ch <= 32) {
                                                ch = 32;
                                            }
                                            b.append((char)ch);
                                            if (b.length() >= max) break;
                                        }
                                        ++i;
                                    }
                                } else {
                                    int ch = 0;
                                    len = 0L;
                                    while ((ch = input.read()) != -1) {
                                        if (ch <= 32) {
                                            ch = 32;
                                        }
                                        b.append((char)ch);
                                        if (b.length() < max) continue;
                                    }
                                }
                                string = b.toString();
                                if (mythread != this.thread) {
                                    this.cleanUp(conn, input, output);
                                    break block38;
                                }
                                this.progressGauge.setValue(8);
                                this.content.setTitle("Body len = " + b.length());
                                if (b.length() > 0) {
                                    this.content.setString(string);
                                } else {
                                    this.content.setString("no data");
                                }
                                this.display.setCurrent((Displayable)this.content);
                                this.progressGauge.setValue(9);
                                this.cleanUp(conn, input, output);
                                break block39;
                            }
                            catch (OutOfMemoryError mem) {
                                b = null;
                                this.content = null;
                                mem.printStackTrace();
                                if (mythread == this.thread) return;
                                this.genErrorsForm("Memory", mem);
                                this.display.setCurrent((Displayable)this.errorsForm);
                                return;
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                                this.genErrorsForm("Errors", ex);
                                this.display.setCurrent((Displayable)this.errorsForm);
                                return;
                            }
                        }
                        this.progressGauge.setValue(10);
                        return;
                    }
                    if (mythread != this.thread) return;
                    this.progressGauge.setValue(10);
                    return;
                }
                if (mythread != this.thread) return;
                this.progressGauge.setValue(10);
                return;
            }
            if (mythread != this.thread) return;
            this.progressGauge.setValue(10);
            return;
        }
        if (mythread != this.thread) return;
        this.progressGauge.setValue(10);
        return;
        finally {
            this.cleanUp(conn, input, output);
            if (mythread == this.thread) {
                this.progressGauge.setValue(10);
            }
        }
    }

    void cleanUp(HttpConnection conn, InputStream input, OutputStream output) {
        block11: {
            Thread mythread;
            block10: {
                block9: {
                    mythread = Thread.currentThread();
                    try {
                        if (input != null) {
                            input.close();
                        }
                    }
                    catch (IOException e) {
                        if (mythread != this.thread) break block9;
                        this.genErrorsForm("InputStream close error", e);
                    }
                }
                try {
                    if (output != null) {
                        output.close();
                    }
                }
                catch (IOException e) {
                    if (mythread != this.thread) break block10;
                    this.genErrorsForm("OutStream close error", e);
                }
            }
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (IOException e) {
                if (mythread != this.thread) break block11;
                this.genErrorsForm("HttpConnection close error", e);
            }
        }
    }

    HttpConnection handleRedirects(HttpConnection c) throws IOException {
        block3: while (true) {
            int code = c.getResponseCode();
            switch (code) {
                case 301: 
                case 302: 
                case 307: {
                    String loc = c.getHeaderField("location");
                    c.close();
                    this.showAlert("Redirecting to " + loc, null);
                    this.progressGauge.setLabel(loc);
                    c = (HttpConnection)Connector.open((String)loc);
                    continue block3;
                }
            }
            break;
        }
        return c;
    }

    void setConfig(HttpConnection c) throws IOException {
        String conf = System.getProperty("microedition.configuration");
        String prof = System.getProperty("microedition.profiles");
        int space = prof.indexOf(32);
        if (space != -1) {
            prof = prof.substring(0, space - 1);
        }
        String platform = System.getProperty("microedition.platform");
        String locale = System.getProperty("microedition.locale");
        String ua = "Profile/" + prof + " Configuration/" + conf + " Platform/" + platform;
        c.setRequestProperty("User-Agent", ua);
        if (locale != null) {
            c.setRequestProperty("Content-Language", locale);
        }
    }

    void genHeaderForm(HttpConnection c) throws IOException {
        String key;
        this.clearForm(this.headerForm);
        this.headerForm.append((Item)new StringItem("response message: ", c.getResponseMessage()));
        this.headerForm.append((Item)new StringItem("response code: ", c.getResponseCode() + ""));
        int i = 0;
        while ((key = c.getHeaderFieldKey(i)) != null) {
            String value = c.getHeaderField(i);
            StringItem item = new StringItem(key + ": ", value);
            this.headerForm.append((Item)item);
            ++i;
        }
    }

    void genRequestForm(HttpConnection c) throws IOException {
        this.clearForm(this.requestForm);
        this.requestForm.append((Item)new StringItem("URL: ", c.getURL()));
        this.requestForm.append((Item)new StringItem("Method: ", c.getRequestMethod()));
        this.requestForm.append((Item)new StringItem("Protocol: ", c.getProtocol()));
        this.requestForm.append((Item)new StringItem("Host: ", c.getHost()));
        this.requestForm.append((Item)new StringItem("File: ", c.getFile()));
        this.requestForm.append((Item)new StringItem("Ref: ", c.getRef()));
        this.requestForm.append((Item)new StringItem("Query: ", c.getQuery()));
        this.requestForm.append((Item)new StringItem("Port: ", Integer.toString(c.getPort())));
        this.requestForm.append((Item)new StringItem("User-Agent: ", c.getRequestProperty("User-Agent")));
        this.requestForm.append((Item)new StringItem("Content-Language: ", c.getRequestProperty("Content-Language")));
    }

    void genProgressForm(String name, String url) {
        this.progressGauge.setValue(0);
        this.progressGauge.setLabel(url);
        this.progressForm.setTitle(name);
    }

    void genErrorsForm(String s, Throwable ex) {
        this.clearForm(this.errorsForm);
        if (s != null) {
            this.errorsForm.setTitle(s);
        } else {
            this.errorsForm.setTitle("Exception");
        }
        if (ex != null) {
            ex.printStackTrace();
            this.errorsForm.append(ex.getClass().getName());
            this.errorsForm.append("\n");
            String m = ex.getMessage();
            if (m != null) {
                this.errorsForm.append(m);
            }
        } else {
            this.errorsForm.append("None");
        }
    }

    void showAlert(String s, Screen next) {
        this.alert.setString(s);
        if (next == null) {
            this.display.setCurrent((Displayable)this.alert);
        } else {
            this.display.setCurrent(this.alert, (Displayable)next);
        }
    }

    void clearForm(Form form) {
        int s = form.size();
        for (int i = s - 1; i >= 0; --i) {
            form.delete(i);
        }
    }
}

