/*
 * Decompiled with CFR 0.152.
 */
package example.http2;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.PushRegistry;
import javax.microedition.io.ServerSocketConnection;
import javax.microedition.io.SocketConnection;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.List;
import javax.microedition.midlet.MIDlet;

public class PushExample
extends MIDlet
implements CommandListener {
    Command exitCommand = new Command("Exit", 7, 2);
    List urlList;
    Vector urls;
    Alert alert;
    static final int DefaultTimeout = 2000;
    Image newsHoundImage;
    boolean imageLoaded;
    Display display = Display.getDisplay((MIDlet)this);
    String url;

    public void startApp() {
        try {
            this.newsHoundImage = Image.createImage((String)"/example/http2/images/newshound.png");
            this.imageLoaded = true;
        }
        catch (IOException ex) {
            System.err.println("Image is not loaded :" + this.imageLoaded);
        }
        this.alert = new Alert("News Hound", "", this.newsHoundImage, AlertType.INFO);
        this.alert.setTimeout(2000);
        this.setupList();
        String[] connections = PushRegistry.listConnections((boolean)true);
        String pushProperty = this.getAppProperty("MIDlet-Push-1");
        if (connections != null && connections.length > 0) {
            String newurl = "Pushed URL Placeholder";
            try {
                String midlet = PushRegistry.getMIDlet((String)connections[0]);
                String filter = PushRegistry.getFilter((String)connections[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (connections[0].startsWith("socket://")) {
                try {
                    ServerSocketConnection scn = (ServerSocketConnection)Connector.open((String)connections[0]);
                    SocketConnection sc = (SocketConnection)scn.acceptAndOpen();
                    DataInputStream dis = sc.openDataInputStream();
                    byte[] buf = new byte[256];
                    int endofline = 0;
                    int count = dis.read(buf);
                    for (int i = 0; i < count; ++i) {
                        if (buf[i] != 10) continue;
                        endofline = i;
                        break;
                    }
                    newurl = new String(buf, 0, endofline);
                    dis.close();
                    sc.close();
                    scn.close();
                }
                catch (IOException e) {
                    System.err.println("******* io exception in push example");
                    e.printStackTrace();
                }
            } else {
                System.err.println(" NYI - unknown connection type");
            }
            this.urlList.append(newurl, null);
            this.urls.addElement(newurl);
        } else {
            connections = PushRegistry.listConnections((boolean)false);
        }
        this.display.setCurrent(this.alert, (Displayable)this.urlList);
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean unconditional) {
    }

    void setupList() {
        String nthURL;
        String url;
        this.urls = new Vector();
        this.urlList = new List("News Headlines", 3);
        this.urlList.setFitPolicy(2);
        this.urlList.addCommand(this.exitCommand);
        this.urlList.setCommandListener((CommandListener)this);
        for (int n = 1; n < 100 && (url = this.getAppProperty(nthURL = "ViewURL-" + n)) != null && url.length() != 0; ++n) {
            String nthTitle = "ViewTitle-" + n;
            String title = this.getAppProperty(nthTitle);
            if (title == null || title.length() == 0) {
                title = url;
            }
            this.urls.addElement(url);
            this.urlList.append(title, null);
        }
        this.urlList.append("Next InComing News: ", null);
    }

    public void commandAction(Command c, Displayable s) {
        try {
            if (c == this.exitCommand) {
                this.destroyApp(false);
                this.notifyDestroyed();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

